/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.internal.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.codetome.hexameter.api.AxialCoordinate;
import org.codetome.hexameter.api.Hexagon;
import org.codetome.hexameter.api.HexagonOrientation;
import org.codetome.hexameter.api.Point;
import org.codetome.hexameter.api.SatelliteData;
import org.codetome.hexameter.internal.SharedHexagonData;

public class HexagonImpl
implements Hexagon {
    private static final long serialVersionUID = -6658255569921274603L;
    private final SharedHexagonData sharedData;
    private final AxialCoordinate coordinate;
    private final AtomicReference<Object> satelliteData;

    private HexagonImpl(SharedHexagonData sharedHexagonData, AxialCoordinate coordinate) {
        this.sharedData = sharedHexagonData;
        this.satelliteData = new AtomicReference();
        this.coordinate = coordinate;
    }

    public static Hexagon newHexagon(SharedHexagonData sharedHexagonData, AxialCoordinate coordinate) {
        return new HexagonImpl(sharedHexagonData, coordinate);
    }

    @Override
    public String getId() {
        return this.coordinate.toKey();
    }

    public String toString() {
        return "HexagonImpl#{x=" + this.coordinate.getGridX() + ", z=" + this.coordinate.getGridZ() + "}";
    }

    @Override
    public final List<Point> getPoints() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < 6; ++i) {
            double angle = 1.0471975511965976 * (double)((float)i + this.sharedData.getOrientation().getCoordinateOffset());
            double x = this.getCenterX() + this.sharedData.getRadius() * Math.cos(angle);
            double y = this.getCenterY() + this.sharedData.getRadius() * Math.sin(angle);
            points.add(Point.fromPosition(x, y));
        }
        return points;
    }

    @Override
    public final <T extends SatelliteData> Optional<T> getSatelliteData() {
        Object result = this.satelliteData.get();
        return result == null ? Optional.empty() : Optional.of((SatelliteData)result);
    }

    @Override
    public final <T extends SatelliteData> void setSatelliteData(T satelliteData) {
        this.satelliteData.set(satelliteData);
    }

    @Override
    public void clearSatelliteData() {
        this.setSatelliteData(null);
    }

    @Override
    public AxialCoordinate getAxialCoordinate() {
        return this.coordinate;
    }

    @Override
    public int getGridX() {
        return this.coordinate.getGridX();
    }

    @Override
    public final int getGridY() {
        return -(this.coordinate.getGridX() + this.coordinate.getGridZ());
    }

    @Override
    public int getGridZ() {
        return this.coordinate.getGridZ();
    }

    @Override
    public final double getCenterX() {
        if (HexagonOrientation.FLAT_TOP.equals((Object)this.sharedData.getOrientation())) {
            return (double)this.coordinate.getGridX() * this.sharedData.getWidth() + this.sharedData.getRadius();
        }
        return (double)this.coordinate.getGridX() * this.sharedData.getWidth() + (double)this.coordinate.getGridZ() * this.sharedData.getWidth() / 2.0 + this.sharedData.getWidth() / 2.0;
    }

    @Override
    public final double getCenterY() {
        if (HexagonOrientation.FLAT_TOP.equals((Object)this.sharedData.getOrientation())) {
            return (double)this.coordinate.getGridZ() * this.sharedData.getHeight() + (double)this.coordinate.getGridX() * this.sharedData.getHeight() / 2.0 + this.sharedData.getHeight() / 2.0;
        }
        return (double)this.coordinate.getGridZ() * this.sharedData.getHeight() + this.sharedData.getRadius();
    }
}

