/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.internal.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.codetome.hexameter.api.AxialCoordinate;
import org.codetome.hexameter.api.CoordinateConverter;
import org.codetome.hexameter.api.Hexagon;
import org.codetome.hexameter.api.HexagonalGrid;
import org.codetome.hexameter.api.HexagonalGridBuilder;
import org.codetome.hexameter.api.Point;
import org.codetome.hexameter.api.exception.HexagonNotFoundException;
import org.codetome.hexameter.internal.SharedHexagonData;
import org.codetome.hexameter.internal.impl.HexagonImpl;
import org.codetome.hexameter.internal.impl.layoutstrategy.GridLayoutStrategy;

public final class HexagonalGridImpl
implements HexagonalGrid {
    private static final int[][] NEIGHBORS = new int[][]{{1, 0}, {1, -1}, {0, -1}, {-1, 0}, {-1, 1}, {0, 1}};
    private static final int NEIGHBOR_X_INDEX = 0;
    private static final int NEIGHBOR_Z_INDEX = 1;
    private final GridLayoutStrategy gridLayoutStrategy;
    private final SharedHexagonData sharedHexagonData;
    private final Map<String, Hexagon> hexagonStorage;

    public HexagonalGridImpl(HexagonalGridBuilder builder) {
        this.sharedHexagonData = builder.getSharedHexagonData();
        this.gridLayoutStrategy = builder.getGridLayoutStrategy();
        this.hexagonStorage = builder.getCustomStorage();
        this.gridLayoutStrategy.createHexagons(builder).forEach(hex -> this.hexagonStorage.put(hex.getId(), (Hexagon)hex));
    }

    @Override
    public Iterable<Hexagon> getHexagons() {
        return new HashSet<Hexagon>(this.hexagonStorage.values());
    }

    @Override
    public Iterable<Hexagon> getHexagonsByAxialRange(AxialCoordinate from, AxialCoordinate to) {
        return IntStream.rangeClosed(from.getGridX(), to.getGridX()).parallel().mapToObj(x -> IntStream.rangeClosed(from.getGridZ(), to.getGridZ()).mapToObj(z -> this.getByAxialCoordinate(AxialCoordinate.fromCoordinates(x, z)))).flatMap(BaseStream::sequential).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    @Override
    public Iterable<Hexagon> getHexagonsByOffsetRange(int gridXFrom, int gridXTo, int gridYFrom, int gridYTo) {
        return IntStream.rangeClosed(gridXFrom, gridXTo).parallel().mapToObj(x -> IntStream.rangeClosed(gridYFrom, gridYTo).mapToObj(y -> {
            int axialX = CoordinateConverter.convertOffsetCoordinatesToAxialX(x, y, this.sharedHexagonData.getOrientation());
            int axialZ = CoordinateConverter.convertOffsetCoordinatesToAxialZ(x, y, this.sharedHexagonData.getOrientation());
            AxialCoordinate axialCoordinate = AxialCoordinate.fromCoordinates(axialX, axialZ);
            return this.getByAxialCoordinate(axialCoordinate);
        })).flatMap(BaseStream::sequential).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    @Override
    public Hexagon addHexagon(AxialCoordinate coordinate) {
        return this.hexagonStorage.put(coordinate.toKey(), HexagonImpl.newHexagon(this.sharedHexagonData, coordinate));
    }

    @Override
    public Hexagon removeHexagon(AxialCoordinate coordinate) {
        this.checkCoordinate(coordinate);
        return this.hexagonStorage.remove(coordinate.toKey());
    }

    @Override
    public boolean containsAxialCoordinate(AxialCoordinate coordinate) {
        return this.hexagonStorage.containsKey(coordinate.toKey());
    }

    @Override
    public Optional<Hexagon> getByAxialCoordinate(AxialCoordinate coordinate) {
        return this.containsAxialCoordinate(coordinate) ? Optional.of(this.hexagonStorage.get(coordinate.toKey())) : Optional.empty();
    }

    private void checkCoordinate(AxialCoordinate coordinate) {
        if (!this.containsAxialCoordinate(coordinate)) {
            throw new HexagonNotFoundException("Coordinate is off the grid: " + coordinate.toKey());
        }
    }

    @Override
    public Optional<Hexagon> getByPixelCoordinate(double x, double y) {
        Hexagon trueHex;
        int estimatedGridX = (int)(x / this.sharedHexagonData.getWidth());
        int estimatedGridZ = (int)(y / this.sharedHexagonData.getHeight());
        AxialCoordinate estimatedCoordinate = AxialCoordinate.fromCoordinates(estimatedGridX = CoordinateConverter.convertOffsetCoordinatesToAxialX(estimatedGridX, estimatedGridZ, this.sharedHexagonData.getOrientation()), estimatedGridZ = CoordinateConverter.convertOffsetCoordinatesToAxialZ(estimatedGridX, estimatedGridZ, this.sharedHexagonData.getOrientation()));
        Hexagon tempHex = HexagonImpl.newHexagon(this.sharedHexagonData, estimatedCoordinate);
        if (this.hexagonsAreAtTheSamePosition(tempHex, trueHex = this.refineHexagonByPixel(tempHex, Point.fromPosition(x, y)))) {
            return this.getByAxialCoordinate(estimatedCoordinate);
        }
        return this.containsAxialCoordinate(trueHex.getAxialCoordinate()) ? Optional.of(trueHex) : Optional.empty();
    }

    @Override
    public Iterable<Hexagon> getNeighborsOf(Hexagon hexagon) {
        HashSet<Hexagon> neighbors = new HashSet<Hexagon>();
        for (int[] neighbor : NEIGHBORS) {
            int neighborGridZ;
            int neighborGridX = hexagon.getGridX() + neighbor[0];
            AxialCoordinate neighborCoordinate = AxialCoordinate.fromCoordinates(neighborGridX, neighborGridZ = hexagon.getGridZ() + neighbor[1]);
            if (!this.containsAxialCoordinate(neighborCoordinate)) continue;
            Hexagon retHex = this.getByAxialCoordinate(neighborCoordinate).get();
            neighbors.add(retHex);
        }
        return neighbors;
    }

    private boolean hexagonsAreAtTheSamePosition(Hexagon hex0, Hexagon hex1) {
        return hex0.getGridX() == hex1.getGridX() && hex0.getGridZ() == hex1.getGridZ();
    }

    private Hexagon refineHexagonByPixel(Hexagon hexagon, Point clickedPoint) {
        Hexagon refined = hexagon;
        double smallestDistance = clickedPoint.distanceFrom(Point.fromPosition(refined.getCenterX(), refined.getCenterY()));
        for (Hexagon neighbor : this.getNeighborsOf(hexagon)) {
            double currentDistance = clickedPoint.distanceFrom(Point.fromPosition(neighbor.getCenterX(), neighbor.getCenterY()));
            if (!(currentDistance < smallestDistance)) continue;
            refined = neighbor;
            smallestDistance = currentDistance;
        }
        return refined;
    }

    @Override
    public void clearSatelliteData() {
        this.hexagonStorage.values().parallelStream().forEach(Hexagon::clearSatelliteData);
    }
}

