/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.internal.impl.layoutstrategy;

import java.util.Collection;
import java.util.HashSet;
import org.codetome.hexameter.api.AxialCoordinate;
import org.codetome.hexameter.api.Hexagon;
import org.codetome.hexameter.api.HexagonOrientation;
import org.codetome.hexameter.api.HexagonalGridBuilder;
import org.codetome.hexameter.internal.impl.HexagonImpl;
import org.codetome.hexameter.internal.impl.layoutstrategy.GridLayoutStrategy;

public final class HexagonalGridLayoutStrategy
implements GridLayoutStrategy {
    @Override
    public Collection<Hexagon> createHexagons(HexagonalGridBuilder builder) {
        double gridSize = builder.getGridHeight();
        HashSet<Hexagon> hexagons = new HashSet<Hexagon>();
        int startX = HexagonOrientation.FLAT_TOP.equals((Object)builder.getOrientation()) ? (int)Math.floor(gridSize / 2.0) : (int)Math.round(gridSize / 4.0);
        int hexRadius = (int)Math.floor(gridSize / 2.0);
        int minX = startX - hexRadius;
        int y = 0;
        while ((double)y < gridSize) {
            int distanceFromMid = Math.abs(hexRadius - y);
            for (int x = Math.max(startX, minX); x <= Math.max(startX, minX) + hexRadius + hexRadius - distanceFromMid; ++x) {
                int gridX = x;
                int gridZ = HexagonOrientation.FLAT_TOP.equals((Object)builder.getOrientation()) ? y - (int)Math.floor(gridSize / 4.0) : y;
                AxialCoordinate coordinate = AxialCoordinate.fromCoordinates(gridX, gridZ);
                hexagons.add(HexagonImpl.newHexagon(builder.getSharedHexagonData(), coordinate));
            }
            --startX;
            ++y;
        }
        return hexagons;
    }

    @Override
    public boolean checkParameters(int gridHeight, int gridWidth) {
        boolean superResult = GridLayoutStrategy.super.checkParameters(gridHeight, gridWidth);
        boolean result = gridHeight == gridWidth && Math.abs(gridHeight % 2) == 1;
        return result && superResult;
    }
}

