/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.internal.impl.layoutstrategy;

import java.util.Collection;
import java.util.HashSet;
import org.codetome.hexameter.api.AxialCoordinate;
import org.codetome.hexameter.api.CoordinateConverter;
import org.codetome.hexameter.api.Hexagon;
import org.codetome.hexameter.api.HexagonalGridBuilder;
import org.codetome.hexameter.internal.impl.HexagonImpl;
import org.codetome.hexameter.internal.impl.layoutstrategy.GridLayoutStrategy;

public final class RectangularGridLayoutStrategy
implements GridLayoutStrategy {
    @Override
    public Collection<Hexagon> createHexagons(HexagonalGridBuilder builder) {
        HashSet<Hexagon> hexagons = new HashSet<Hexagon>();
        for (int y = 0; y < builder.getGridHeight(); ++y) {
            for (int x = 0; x < builder.getGridWidth(); ++x) {
                int gridX = CoordinateConverter.convertOffsetCoordinatesToAxialX(x, y, builder.getOrientation());
                int gridZ = CoordinateConverter.convertOffsetCoordinatesToAxialZ(x, y, builder.getOrientation());
                AxialCoordinate coordinate = AxialCoordinate.fromCoordinates(gridX, gridZ);
                hexagons.add(HexagonImpl.newHexagon(builder.getSharedHexagonData(), coordinate));
            }
        }
        return hexagons;
    }

    @Override
    public boolean checkParameters(int gridHeight, int gridWidth) {
        return GridLayoutStrategy.super.checkParameters(gridHeight, gridWidth);
    }
}

