/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.internal.impl.layoutstrategy;

import java.util.Collection;
import java.util.HashSet;
import org.codetome.hexameter.api.AxialCoordinate;
import org.codetome.hexameter.api.Hexagon;
import org.codetome.hexameter.api.HexagonalGridBuilder;
import org.codetome.hexameter.internal.impl.HexagonImpl;
import org.codetome.hexameter.internal.impl.layoutstrategy.GridLayoutStrategy;

public final class TrapezoidGridLayoutStrategy
implements GridLayoutStrategy {
    @Override
    public Collection<Hexagon> createHexagons(HexagonalGridBuilder builder) {
        HashSet<Hexagon> hexagons = new HashSet<Hexagon>();
        for (int gridZ = 0; gridZ < builder.getGridHeight(); ++gridZ) {
            for (int gridX = 0; gridX < builder.getGridWidth(); ++gridX) {
                AxialCoordinate coordinate = AxialCoordinate.fromCoordinates(gridX, gridZ);
                hexagons.add(HexagonImpl.newHexagon(builder.getSharedHexagonData(), coordinate));
            }
        }
        return hexagons;
    }

    @Override
    public boolean checkParameters(int gridHeight, int gridWidth) {
        return GridLayoutStrategy.super.checkParameters(gridHeight, gridWidth);
    }
}

