/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.internal.impl.layoutstrategy;

import java.util.Collection;
import java.util.HashSet;
import org.codetome.hexameter.api.AxialCoordinate;
import org.codetome.hexameter.api.Hexagon;
import org.codetome.hexameter.api.HexagonalGridBuilder;
import org.codetome.hexameter.internal.impl.HexagonImpl;
import org.codetome.hexameter.internal.impl.layoutstrategy.GridLayoutStrategy;

public final class TriangularGridLayoutStrategy
implements GridLayoutStrategy {
    @Override
    public Collection<Hexagon> createHexagons(HexagonalGridBuilder builder) {
        int gridSize = builder.getGridHeight();
        HashSet<Hexagon> hexagons = new HashSet<Hexagon>();
        for (int gridZ = 0; gridZ < gridSize; ++gridZ) {
            int endX = gridSize - gridZ;
            for (int gridX = 0; gridX < endX; ++gridX) {
                AxialCoordinate coordinate = AxialCoordinate.fromCoordinates(gridX, gridZ);
                hexagons.add(HexagonImpl.newHexagon(builder.getSharedHexagonData(), coordinate));
            }
        }
        return hexagons;
    }

    @Override
    public boolean checkParameters(int gridHeight, int gridWidth) {
        boolean superResult = GridLayoutStrategy.super.checkParameters(gridHeight, gridWidth);
        boolean result = gridHeight == gridWidth;
        return superResult && result;
    }
}

