/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.api;

import java.io.Serializable;
import java.util.Objects;

public final class AxialCoordinate
implements Serializable {
    private static final long serialVersionUID = -6656555565645274603L;
    private final int gridX;
    private final int gridZ;

    private AxialCoordinate(int gridX, int gridZ) {
        this.gridX = gridX;
        this.gridZ = gridZ;
    }

    public static AxialCoordinate fromKey(String key) {
        AxialCoordinate result = null;
        try {
            String[] coords = key.split(",");
            result = AxialCoordinate.fromCoordinates(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create AxialCoordinate from key: " + key, e);
        }
        return result;
    }

    public static AxialCoordinate fromCoordinates(int gridX, int gridZ) {
        return new AxialCoordinate(gridX, gridZ);
    }

    public int hashCode() {
        return Objects.hash(this.gridX, this.gridZ);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AxialCoordinate that = (AxialCoordinate)obj;
        return Objects.equals(this.gridX, that.gridX) && Objects.equals(this.gridZ, that.gridZ);
    }

    public String toKey() {
        return this.gridX + "," + this.gridZ;
    }

    public int getGridX() {
        return this.gridX;
    }

    public int getGridZ() {
        return this.gridZ;
    }
}

