/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.api;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codetome.hexameter.core.api.AxialCoordinate;
import org.codetome.hexameter.core.api.HexagonOrientation;
import org.codetome.hexameter.core.api.HexagonalGrid;
import org.codetome.hexameter.core.api.HexagonalGridCalculator;
import org.codetome.hexameter.core.api.HexagonalGridLayout;
import org.codetome.hexameter.core.api.exception.HexagonalGridCreationException;
import org.codetome.hexameter.core.internal.SharedHexagonData;
import org.codetome.hexameter.core.internal.impl.HexagonalGridCalculatorImpl;
import org.codetome.hexameter.core.internal.impl.HexagonalGridImpl;
import org.codetome.hexameter.core.internal.impl.layoutstrategy.GridLayoutStrategy;

public final class HexagonalGridBuilder {
    private int gridWidth;
    private int gridHeight;
    private double radius;
    private Map<AxialCoordinate, Object> customStorage = new ConcurrentHashMap<AxialCoordinate, Object>();
    private HexagonOrientation orientation = HexagonOrientation.POINTY_TOP;
    private HexagonalGridLayout gridLayout = HexagonalGridLayout.RECTANGULAR;

    public HexagonalGrid build() {
        this.checkParameters();
        return new HexagonalGridImpl(this);
    }

    private void checkParameters() {
        if (this.orientation == null) {
            throw new HexagonalGridCreationException("Orientation must be set.");
        }
        if (this.radius <= 0.0) {
            throw new HexagonalGridCreationException("Radius must be greater than 0.");
        }
        if (this.gridLayout == null) {
            throw new HexagonalGridCreationException("Grid layout must be set.");
        }
        if (!this.gridLayout.checkParameters(this.gridHeight, this.gridWidth)) {
            throw new HexagonalGridCreationException("Width: " + this.gridWidth + " and height: " + this.gridHeight + " is not valid for: " + this.gridLayout.name() + " layout.");
        }
    }

    public HexagonalGridCalculator buildCalculatorFor(HexagonalGrid hexagonalGrid) {
        return new HexagonalGridCalculatorImpl(hexagonalGrid);
    }

    public double getRadius() {
        return this.radius;
    }

    public HexagonalGridBuilder setRadius(double radius) {
        this.radius = radius;
        return this;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public HexagonalGridBuilder setGridWidth(int gridWidth) {
        this.gridWidth = gridWidth;
        return this;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public HexagonalGridBuilder setGridHeight(int gridHeight) {
        this.gridHeight = gridHeight;
        return this;
    }

    public HexagonOrientation getOrientation() {
        return this.orientation;
    }

    public HexagonalGridBuilder setOrientation(HexagonOrientation orientation) {
        this.orientation = orientation;
        return this;
    }

    public GridLayoutStrategy getGridLayoutStrategy() {
        return this.gridLayout.getGridLayoutStrategy();
    }

    public Map<AxialCoordinate, Object> getCustomStorage() {
        return this.customStorage;
    }

    public SharedHexagonData getSharedHexagonData() {
        if (this.orientation == null || this.radius == 0.0) {
            throw new IllegalStateException("orientation or radius is not yet initialized");
        }
        return new SharedHexagonData(this.orientation, this.radius);
    }

    public HexagonalGridLayout getGridLayout() {
        return this.gridLayout;
    }

    public HexagonalGridBuilder setGridLayout(HexagonalGridLayout gridLayout) {
        this.gridLayout = gridLayout;
        return this;
    }
}

