/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.internal;

import org.codetome.hexameter.core.api.HexagonOrientation;

public final class SharedHexagonData {
    private final HexagonOrientation orientation;
    private final double radius;
    private final double height;
    private final double width;

    public SharedHexagonData(HexagonOrientation orientation, double radius) {
        this.orientation = orientation;
        this.radius = radius;
        this.height = HexagonOrientation.FLAT_TOP.equals((Object)orientation) ? this.calculateHeight(radius) : this.calculateWidth(radius);
        this.width = HexagonOrientation.FLAT_TOP.equals((Object)orientation) ? this.calculateWidth(radius) : this.calculateHeight(radius);
    }

    private double calculateHeight(double radius) {
        return Math.sqrt(3.0) * radius;
    }

    private double calculateWidth(double radius) {
        return radius * 3.0 / 2.0;
    }

    public HexagonOrientation getOrientation() {
        return this.orientation;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }
}

