/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.internal.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.codetome.hexameter.core.api.AxialCoordinate;
import org.codetome.hexameter.core.api.Hexagon;
import org.codetome.hexameter.core.api.HexagonOrientation;
import org.codetome.hexameter.core.api.Point;
import org.codetome.hexameter.core.api.SatelliteData;
import org.codetome.hexameter.core.internal.SharedHexagonData;

public class HexagonImpl
implements Hexagon {
    private static final long serialVersionUID = -6658255569921274603L;
    private final AxialCoordinate coordinate;
    private final transient SharedHexagonData sharedData;
    private final transient Map<AxialCoordinate, Object> dataMap;

    private HexagonImpl(SharedHexagonData sharedHexagonData, AxialCoordinate coordinate, Map<AxialCoordinate, Object> dataMap) {
        this.sharedData = sharedHexagonData;
        this.coordinate = coordinate;
        this.dataMap = dataMap;
    }

    public static Hexagon newHexagon(SharedHexagonData sharedHexagonData, AxialCoordinate coordinate, Map<AxialCoordinate, Object> dataMap) {
        return new HexagonImpl(sharedHexagonData, coordinate, dataMap);
    }

    public int hashCode() {
        return Objects.hash(this.coordinate);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HexagonImpl hexagon = (HexagonImpl)obj;
        return Objects.equals(this.coordinate, hexagon.coordinate);
    }

    public String toString() {
        return "HexagonImpl#{x=" + this.coordinate.getGridX() + ", z=" + this.coordinate.getGridZ() + "}";
    }

    @Override
    public String getId() {
        return this.coordinate.toKey();
    }

    @Override
    public final List<Point> getPoints() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < 6; ++i) {
            double angle = 1.0471975511965976 * (double)((float)i + this.sharedData.getOrientation().getCoordinateOffset());
            double x = this.getCenterX() + this.sharedData.getRadius() * Math.cos(angle);
            double y = this.getCenterY() + this.sharedData.getRadius() * Math.sin(angle);
            points.add(Point.fromPosition(x, y));
        }
        return points;
    }

    @Override
    public AxialCoordinate getAxialCoordinate() {
        return this.coordinate;
    }

    @Override
    public int getGridX() {
        return this.coordinate.getGridX();
    }

    @Override
    public final int getGridY() {
        return -(this.coordinate.getGridX() + this.coordinate.getGridZ());
    }

    @Override
    public int getGridZ() {
        return this.coordinate.getGridZ();
    }

    @Override
    public final double getCenterX() {
        if (HexagonOrientation.FLAT_TOP.equals((Object)this.sharedData.getOrientation())) {
            return (double)this.coordinate.getGridX() * this.sharedData.getWidth() + this.sharedData.getRadius();
        }
        return (double)this.coordinate.getGridX() * this.sharedData.getWidth() + (double)this.coordinate.getGridZ() * this.sharedData.getWidth() / 2.0 + this.sharedData.getWidth() / 2.0;
    }

    @Override
    public final double getCenterY() {
        if (HexagonOrientation.FLAT_TOP.equals((Object)this.sharedData.getOrientation())) {
            return (double)this.coordinate.getGridZ() * this.sharedData.getHeight() + (double)this.coordinate.getGridX() * this.sharedData.getHeight() / 2.0 + this.sharedData.getHeight() / 2.0;
        }
        return (double)this.coordinate.getGridZ() * this.sharedData.getHeight() + this.sharedData.getRadius();
    }

    @Override
    public final <T extends SatelliteData> Optional<T> getSatelliteData() {
        Object result = this.dataMap.get(this.getAxialCoordinate());
        return result == null ? Optional.empty() : Optional.of((SatelliteData)result);
    }

    @Override
    public final <T extends SatelliteData> void setSatelliteData(T satelliteData) {
        this.dataMap.put(this.getAxialCoordinate(), satelliteData);
    }

    @Override
    public void clearSatelliteData() {
        this.dataMap.remove(this.getAxialCoordinate());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

