/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.internal.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.codetome.hexameter.core.api.AxialCoordinate;
import org.codetome.hexameter.core.api.CoordinateConverter;
import org.codetome.hexameter.core.api.Hexagon;
import org.codetome.hexameter.core.api.HexagonalGrid;
import org.codetome.hexameter.core.api.HexagonalGridBuilder;
import org.codetome.hexameter.core.api.HexagonalGridLayout;
import org.codetome.hexameter.core.api.Point;
import org.codetome.hexameter.core.internal.SharedHexagonData;
import org.codetome.hexameter.core.internal.impl.HexagonImpl;
import org.codetome.hexameter.core.internal.impl.layoutstrategy.GridLayoutStrategy;

public final class HexagonalGridImpl
implements HexagonalGrid {
    private static final int[][] NEIGHBORS = new int[][]{{1, 0}, {1, -1}, {0, -1}, {-1, 0}, {-1, 1}, {0, 1}};
    private static final int NEIGHBOR_X_INDEX = 0;
    private static final int NEIGHBOR_Z_INDEX = 1;
    private final GridLayoutStrategy gridLayoutStrategy;
    private final HexagonalGridLayout gridLayout;
    private final SharedHexagonData sharedHexagonData;
    private final Map<AxialCoordinate, Object> hexagonStorage;
    private final Set<AxialCoordinate> coordinates;
    private final int gridWidth;
    private final int gridHeight;

    public HexagonalGridImpl(HexagonalGridBuilder builder) {
        this.gridWidth = builder.getGridWidth();
        this.gridHeight = builder.getGridHeight();
        this.sharedHexagonData = builder.getSharedHexagonData();
        this.gridLayoutStrategy = builder.getGridLayoutStrategy();
        this.gridLayout = builder.getGridLayout();
        this.hexagonStorage = builder.getCustomStorage();
        this.coordinates = this.gridLayoutStrategy.fetchGridCoordinates(builder);
    }

    @Override
    public Iterable<Hexagon> getHexagons() {
        return this.coordinates.stream().map(coordinate -> HexagonImpl.newHexagon(this.sharedHexagonData, coordinate, this.hexagonStorage)).collect(Collectors.toList());
    }

    @Override
    public Iterable<Hexagon> getHexagonsByAxialRange(AxialCoordinate from, AxialCoordinate to) {
        return IntStream.rangeClosed(from.getGridX(), to.getGridX()).parallel().mapToObj(x -> IntStream.rangeClosed(from.getGridZ(), to.getGridZ()).mapToObj(z -> this.getByAxialCoordinate(AxialCoordinate.fromCoordinates(x, z)))).flatMap(BaseStream::sequential).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    @Override
    public Iterable<Hexagon> getHexagonsByOffsetRange(int gridXFrom, int gridXTo, int gridYFrom, int gridYTo) {
        return IntStream.rangeClosed(gridXFrom, gridXTo).parallel().mapToObj(x -> IntStream.rangeClosed(gridYFrom, gridYTo).mapToObj(y -> {
            int axialX = CoordinateConverter.convertOffsetCoordinatesToAxialX(x, y, this.sharedHexagonData.getOrientation());
            int axialZ = CoordinateConverter.convertOffsetCoordinatesToAxialZ(x, y, this.sharedHexagonData.getOrientation());
            AxialCoordinate axialCoordinate = AxialCoordinate.fromCoordinates(axialX, axialZ);
            return this.getByAxialCoordinate(axialCoordinate);
        })).flatMap(BaseStream::sequential).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    @Override
    public boolean containsAxialCoordinate(AxialCoordinate coordinate) {
        return this.coordinates.contains(coordinate);
    }

    @Override
    public Optional<Hexagon> getByAxialCoordinate(AxialCoordinate coordinate) {
        return this.containsAxialCoordinate(coordinate) ? Optional.of(HexagonImpl.newHexagon(this.sharedHexagonData, coordinate, this.hexagonStorage)) : Optional.empty();
    }

    @Override
    public Optional<Hexagon> getByPixelCoordinate(double coordinateX, double coordinateY) {
        Hexagon trueHex;
        int estimatedGridX = (int)(coordinateX / this.sharedHexagonData.getWidth());
        int estimatedGridZ = (int)(coordinateY / this.sharedHexagonData.getHeight());
        AxialCoordinate estimatedCoordinate = AxialCoordinate.fromCoordinates(estimatedGridX = CoordinateConverter.convertOffsetCoordinatesToAxialX(estimatedGridX, estimatedGridZ, this.sharedHexagonData.getOrientation()), estimatedGridZ = CoordinateConverter.convertOffsetCoordinatesToAxialZ(estimatedGridX, estimatedGridZ, this.sharedHexagonData.getOrientation()));
        Hexagon tempHex = HexagonImpl.newHexagon(this.sharedHexagonData, estimatedCoordinate, this.hexagonStorage);
        if (this.hexagonsAreAtTheSamePosition(tempHex, trueHex = this.refineHexagonByPixel(tempHex, Point.fromPosition(coordinateX, coordinateY)))) {
            return this.getByAxialCoordinate(estimatedCoordinate);
        }
        return this.containsAxialCoordinate(trueHex.getAxialCoordinate()) ? Optional.of(trueHex) : Optional.empty();
    }

    @Override
    public Iterable<Hexagon> getNeighborsOf(Hexagon hexagon) {
        HashSet<Hexagon> neighbors = new HashSet<Hexagon>();
        for (int[] neighbor : NEIGHBORS) {
            int neighborGridZ;
            int neighborGridX = hexagon.getGridX() + neighbor[0];
            AxialCoordinate neighborCoordinate = AxialCoordinate.fromCoordinates(neighborGridX, neighborGridZ = hexagon.getGridZ() + neighbor[1]);
            if (!this.containsAxialCoordinate(neighborCoordinate)) continue;
            Hexagon retHex = this.getByAxialCoordinate(neighborCoordinate).get();
            neighbors.add(retHex);
        }
        return neighbors;
    }

    @Override
    public void clearSatelliteData() {
        this.hexagonStorage.clear();
    }

    public HexagonalGridLayout getGridLayout() {
        return this.gridLayout;
    }

    public SharedHexagonData getSharedHexagonData() {
        return this.sharedHexagonData;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    private boolean hexagonsAreAtTheSamePosition(Hexagon hex0, Hexagon hex1) {
        return hex0.getGridX() == hex1.getGridX() && hex0.getGridZ() == hex1.getGridZ();
    }

    private Hexagon refineHexagonByPixel(Hexagon hexagon, Point clickedPoint) {
        Hexagon refined = hexagon;
        double smallestDistance = clickedPoint.distanceFrom(Point.fromPosition(refined.getCenterX(), refined.getCenterY()));
        for (Hexagon neighbor : this.getNeighborsOf(hexagon)) {
            double currentDistance = clickedPoint.distanceFrom(Point.fromPosition(neighbor.getCenterX(), neighbor.getCenterY()));
            if (!(currentDistance < smallestDistance)) continue;
            refined = neighbor;
            smallestDistance = currentDistance;
        }
        return refined;
    }
}

