/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.internal.impl.layoutstrategy;

import java.util.LinkedHashSet;
import java.util.Set;
import org.codetome.hexameter.core.api.AxialCoordinate;
import org.codetome.hexameter.core.api.HexagonOrientation;
import org.codetome.hexameter.core.api.HexagonalGridBuilder;
import org.codetome.hexameter.core.internal.impl.layoutstrategy.GridLayoutStrategy;

public final class HexagonalGridLayoutStrategy
implements GridLayoutStrategy {
    @Override
    public Set<AxialCoordinate> fetchGridCoordinates(HexagonalGridBuilder builder) {
        LinkedHashSet<AxialCoordinate> coordinates = new LinkedHashSet<AxialCoordinate>();
        double gridSize = builder.getGridHeight();
        int startX = HexagonOrientation.FLAT_TOP.equals((Object)builder.getOrientation()) ? (int)Math.floor(gridSize / 2.0) : (int)Math.round(gridSize / 4.0);
        int hexRadius = (int)Math.floor(gridSize / 2.0);
        int minX = startX - hexRadius;
        int y = 0;
        while ((double)y < gridSize) {
            int distanceFromMid = Math.abs(hexRadius - y);
            for (int x = Math.max(startX, minX); x <= Math.max(startX, minX) + hexRadius + hexRadius - distanceFromMid; ++x) {
                int gridX = x;
                int gridZ = HexagonOrientation.FLAT_TOP.equals((Object)builder.getOrientation()) ? y - (int)Math.floor(gridSize / 4.0) : y;
                coordinates.add(AxialCoordinate.fromCoordinates(gridX, gridZ));
            }
            --startX;
            ++y;
        }
        return coordinates;
    }

    @Override
    public boolean checkParameters(int gridHeight, int gridWidth) {
        boolean superResult = GridLayoutStrategy.super.checkParameters(gridHeight, gridWidth);
        boolean result = gridHeight == gridWidth && Math.abs(gridHeight % 2) == 1;
        return result && superResult;
    }
}

