/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.internal.impl.layoutstrategy;

import java.util.LinkedHashSet;
import java.util.Set;
import org.codetome.hexameter.core.api.AxialCoordinate;
import org.codetome.hexameter.core.api.CoordinateConverter;
import org.codetome.hexameter.core.api.HexagonalGridBuilder;
import org.codetome.hexameter.core.internal.impl.layoutstrategy.GridLayoutStrategy;

public final class RectangularGridLayoutStrategy
implements GridLayoutStrategy {
    @Override
    public Set<AxialCoordinate> fetchGridCoordinates(HexagonalGridBuilder builder) {
        LinkedHashSet<AxialCoordinate> coordinates = new LinkedHashSet<AxialCoordinate>();
        for (int y = 0; y < builder.getGridHeight(); ++y) {
            for (int x = 0; x < builder.getGridWidth(); ++x) {
                int gridX = CoordinateConverter.convertOffsetCoordinatesToAxialX(x, y, builder.getOrientation());
                int gridZ = CoordinateConverter.convertOffsetCoordinatesToAxialZ(x, y, builder.getOrientation());
                coordinates.add(AxialCoordinate.fromCoordinates(gridX, gridZ));
            }
        }
        return coordinates;
    }

    @Override
    public boolean checkParameters(int gridHeight, int gridWidth) {
        return GridLayoutStrategy.super.checkParameters(gridHeight, gridWidth);
    }
}

