/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.internal.impl.layoutstrategy;

import java.util.LinkedHashSet;
import java.util.Set;
import org.codetome.hexameter.core.api.AxialCoordinate;
import org.codetome.hexameter.core.api.HexagonalGridBuilder;
import org.codetome.hexameter.core.internal.impl.layoutstrategy.GridLayoutStrategy;

public final class TriangularGridLayoutStrategy
implements GridLayoutStrategy {
    @Override
    public Set<AxialCoordinate> fetchGridCoordinates(HexagonalGridBuilder builder) {
        LinkedHashSet<AxialCoordinate> coordinates = new LinkedHashSet<AxialCoordinate>();
        int gridSize = builder.getGridHeight();
        for (int gridZ = 0; gridZ < gridSize; ++gridZ) {
            int endX = gridSize - gridZ;
            for (int gridX = 0; gridX < endX; ++gridX) {
                coordinates.add(AxialCoordinate.fromCoordinates(gridX, gridZ));
            }
        }
        return coordinates;
    }

    @Override
    public boolean checkParameters(int gridHeight, int gridWidth) {
        boolean superResult = GridLayoutStrategy.super.checkParameters(gridHeight, gridWidth);
        boolean result = gridHeight == gridWidth;
        return superResult && result;
    }
}

