/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.api;

import java.io.Serializable;

public final class AxialCoordinate
implements Serializable {
    private static final long serialVersionUID = -6656555565645274603L;
    private final int gridX;
    private final int gridZ;

    private AxialCoordinate(int gridX, int gridZ) {
        this.gridX = gridX;
        this.gridZ = gridZ;
    }

    public static AxialCoordinate fromKey(String key) {
        AxialCoordinate result;
        try {
            String[] coords = key.split(",");
            result = AxialCoordinate.fromCoordinates(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create AxialCoordinate from key: " + key, e);
        }
        return result;
    }

    public static AxialCoordinate fromCoordinates(int gridX, int gridZ) {
        return new AxialCoordinate(gridX, gridZ);
    }

    public String toKey() {
        return this.gridX + "," + this.gridZ;
    }

    public int getGridX() {
        return this.gridX;
    }

    public int getGridZ() {
        return this.gridZ;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AxialCoordinate)) {
            return false;
        }
        AxialCoordinate other = (AxialCoordinate)o;
        if (this.getGridX() != other.getGridX()) {
            return false;
        }
        return this.getGridZ() == other.getGridZ();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getGridX();
        result = result * 59 + this.getGridZ();
        return result;
    }

    public String toString() {
        return "AxialCoordinate(gridX=" + this.getGridX() + ", gridZ=" + this.getGridZ() + ")";
    }
}

