/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.internal.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codetome.hexameter.core.api.AxialCoordinate;
import org.codetome.hexameter.core.api.Hexagon;
import org.codetome.hexameter.core.api.HexagonOrientation;
import org.codetome.hexameter.core.api.Point;
import org.codetome.hexameter.core.api.SatelliteData;
import org.codetome.hexameter.core.backport.Optional;
import org.codetome.hexameter.core.internal.GridData;

public class HexagonImpl
implements Hexagon {
    private final AxialCoordinate coordinate;
    private final transient GridData sharedData;
    private final transient Map<AxialCoordinate, Object> dataMap;

    private HexagonImpl(GridData gridData, AxialCoordinate coordinate, Map<AxialCoordinate, Object> dataMap) {
        this.sharedData = gridData;
        this.coordinate = coordinate;
        this.dataMap = dataMap;
    }

    public static Hexagon newHexagon(GridData gridData, AxialCoordinate coordinate, Map<AxialCoordinate, Object> dataMap) {
        return new HexagonImpl(gridData, coordinate, dataMap);
    }

    @Override
    public String getId() {
        return this.coordinate.toKey();
    }

    public final List<Point> getPoints() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < 6; ++i) {
            double angle = 1.0471975511965976 * (double)((float)i + this.sharedData.getOrientation().getCoordinateOffset());
            double x = this.getCenterX() + this.sharedData.getRadius() * Math.cos(angle);
            double y = this.getCenterY() + this.sharedData.getRadius() * Math.sin(angle);
            points.add(Point.fromPosition(x, y));
        }
        return points;
    }

    @Override
    public AxialCoordinate getAxialCoordinate() {
        return this.coordinate;
    }

    @Override
    public int getGridX() {
        return this.coordinate.getGridX();
    }

    @Override
    public final int getGridY() {
        return -(this.coordinate.getGridX() + this.coordinate.getGridZ());
    }

    @Override
    public int getGridZ() {
        return this.coordinate.getGridZ();
    }

    @Override
    public final double getCenterX() {
        if (HexagonOrientation.FLAT_TOP.equals((Object)this.sharedData.getOrientation())) {
            return (double)this.coordinate.getGridX() * this.sharedData.getHexagonWidth() + this.sharedData.getRadius();
        }
        return (double)this.coordinate.getGridX() * this.sharedData.getHexagonWidth() + (double)this.coordinate.getGridZ() * this.sharedData.getHexagonWidth() / 2.0 + this.sharedData.getHexagonWidth() / 2.0;
    }

    @Override
    public final double getCenterY() {
        if (HexagonOrientation.FLAT_TOP.equals((Object)this.sharedData.getOrientation())) {
            return (double)this.coordinate.getGridZ() * this.sharedData.getHexagonHeight() + (double)this.coordinate.getGridX() * this.sharedData.getHexagonHeight() / 2.0 + this.sharedData.getHexagonHeight() / 2.0;
        }
        return (double)this.coordinate.getGridZ() * this.sharedData.getHexagonHeight() + this.sharedData.getRadius();
    }

    @Override
    public final <T extends SatelliteData> Optional<T> getSatelliteData() {
        Object result = this.dataMap.get(this.getAxialCoordinate());
        return result == null ? Optional.empty() : Optional.of((SatelliteData)result);
    }

    @Override
    public final <T extends SatelliteData> void setSatelliteData(T satelliteData) {
        this.dataMap.put(this.getAxialCoordinate(), satelliteData);
    }

    @Override
    public void clearSatelliteData() {
        this.dataMap.remove(this.getAxialCoordinate());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HexagonImpl)) {
            return false;
        }
        HexagonImpl other = (HexagonImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AxialCoordinate this$coordinate = this.coordinate;
        AxialCoordinate other$coordinate = other.coordinate;
        return !(this$coordinate == null ? other$coordinate != null : !((Object)this$coordinate).equals(other$coordinate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HexagonImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AxialCoordinate $coordinate = this.coordinate;
        result = result * 59 + ($coordinate == null ? 43 : ((Object)$coordinate).hashCode());
        return result;
    }

    public String toString() {
        return "HexagonImpl(coordinate=" + this.coordinate + ")";
    }
}

