/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.internal.impl;

import java.util.HashSet;
import java.util.Set;
import org.codetome.hexameter.core.api.AxialCoordinate;
import org.codetome.hexameter.core.api.Hexagon;
import org.codetome.hexameter.core.api.HexagonalGrid;
import org.codetome.hexameter.core.api.HexagonalGridCalculator;

public final class HexagonalGridCalculatorImpl
implements HexagonalGridCalculator {
    private final HexagonalGrid hexagonalGrid;

    public HexagonalGridCalculatorImpl(HexagonalGrid hexagonalGrid) {
        this.hexagonalGrid = hexagonalGrid;
    }

    @Override
    public int calculateDistanceBetween(Hexagon hex0, Hexagon hex1) {
        double absX = Math.abs(hex0.getGridX() - hex1.getGridX());
        double absY = Math.abs(hex0.getGridY() - hex1.getGridY());
        double absZ = Math.abs(hex0.getGridZ() - hex1.getGridZ());
        return (int)Math.max(Math.max(absX, absY), absZ);
    }

    @Override
    public Set<Hexagon> calculateMovementRangeFrom(Hexagon hexagon, int distance) {
        HashSet<Hexagon> ret = new HashSet<Hexagon>();
        for (int x = -distance; x <= distance; ++x) {
            for (int y = Math.max(-distance, -x - distance); y <= Math.min(distance, -x + distance); ++y) {
                int tmpZ;
                int z = -x - y;
                int tmpX = hexagon.getGridX() + x;
                AxialCoordinate tempCoordinate = AxialCoordinate.fromCoordinates(tmpX, tmpZ = hexagon.getGridZ() + z);
                if (!this.hexagonalGrid.containsAxialCoordinate(tempCoordinate)) continue;
                Hexagon hex = this.hexagonalGrid.getByAxialCoordinate(tempCoordinate).get();
                ret.add(hex);
            }
        }
        return ret;
    }
}

