/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.internal.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.codetome.hexameter.core.api.AxialCoordinate;
import org.codetome.hexameter.core.api.CoordinateConverter;
import org.codetome.hexameter.core.api.Hexagon;
import org.codetome.hexameter.core.api.HexagonalGrid;
import org.codetome.hexameter.core.api.HexagonalGridBuilder;
import org.codetome.hexameter.core.api.Point;
import org.codetome.hexameter.core.backport.Optional;
import org.codetome.hexameter.core.internal.GridData;
import org.codetome.hexameter.core.internal.impl.HexagonImpl;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;

public final class HexagonalGridImpl
implements HexagonalGrid {
    private static final int[][] NEIGHBORS = new int[][]{{1, 0}, {1, -1}, {0, -1}, {-1, 0}, {-1, 1}, {0, 1}};
    private static final int NEIGHBOR_X_INDEX = 0;
    private static final int NEIGHBOR_Z_INDEX = 1;
    private final GridData gridData;
    private final Map<AxialCoordinate, Object> hexagonStorage;
    private final Set<AxialCoordinate> coordinates;

    public HexagonalGridImpl(HexagonalGridBuilder builder) {
        this.gridData = builder.getGridData();
        this.hexagonStorage = builder.getCustomStorage();
        this.coordinates = new LinkedHashSet<AxialCoordinate>();
        builder.getGridLayoutStrategy().fetchGridCoordinates(builder).subscribe((Action1)new Action1<AxialCoordinate>(){

            public void call(AxialCoordinate axialCoordinate) {
                HexagonalGridImpl.this.coordinates.add(axialCoordinate);
            }
        });
    }

    @Override
    public Observable<Hexagon> getHexagons() {
        Observable result = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Hexagon>(){

            public void call(Subscriber<? super Hexagon> subscriber) {
                Iterator coordinateIterator = HexagonalGridImpl.this.coordinates.iterator();
                while (coordinateIterator.hasNext()) {
                    subscriber.onNext((Object)HexagonImpl.newHexagon(HexagonalGridImpl.this.gridData, (AxialCoordinate)coordinateIterator.next(), HexagonalGridImpl.this.hexagonStorage));
                }
                subscriber.onCompleted();
            }
        });
        return result;
    }

    @Override
    public Observable<Hexagon> getHexagonsByAxialRange(final AxialCoordinate from, final AxialCoordinate to) {
        Observable result = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Hexagon>(){

            public void call(Subscriber<? super Hexagon> subscriber) {
                for (int gridZ = from.getGridZ(); gridZ <= to.getGridZ(); ++gridZ) {
                    for (int gridX = from.getGridX(); gridX <= to.getGridX(); ++gridX) {
                        AxialCoordinate currentCoordinate = AxialCoordinate.fromCoordinates(gridX, gridZ);
                        if (!HexagonalGridImpl.this.containsAxialCoordinate(currentCoordinate)) continue;
                        subscriber.onNext((Object)HexagonalGridImpl.this.getByAxialCoordinate(currentCoordinate).get());
                    }
                }
                subscriber.onCompleted();
            }
        });
        return result;
    }

    @Override
    public Observable<Hexagon> getHexagonsByOffsetRange(final int gridXFrom, final int gridXTo, final int gridYFrom, final int gridYTo) {
        Observable result = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Hexagon>(){

            public void call(Subscriber<? super Hexagon> subscriber) {
                for (int gridX = gridXFrom; gridX <= gridXTo; ++gridX) {
                    for (int gridY = gridYFrom; gridY <= gridYTo; ++gridY) {
                        int axialZ;
                        int axialX = CoordinateConverter.convertOffsetCoordinatesToAxialX(gridX, gridY, HexagonalGridImpl.this.gridData.getOrientation());
                        AxialCoordinate axialCoordinate = AxialCoordinate.fromCoordinates(axialX, axialZ = CoordinateConverter.convertOffsetCoordinatesToAxialZ(gridX, gridY, HexagonalGridImpl.this.gridData.getOrientation()));
                        Optional<Hexagon> hex = HexagonalGridImpl.this.getByAxialCoordinate(axialCoordinate);
                        if (!hex.isPresent()) continue;
                        subscriber.onNext((Object)hex.get());
                    }
                }
                subscriber.onCompleted();
            }
        });
        return result;
    }

    @Override
    public boolean containsAxialCoordinate(AxialCoordinate coordinate) {
        return this.coordinates.contains(coordinate);
    }

    @Override
    public Optional<Hexagon> getByAxialCoordinate(AxialCoordinate coordinate) {
        return this.containsAxialCoordinate(coordinate) ? Optional.of(HexagonImpl.newHexagon(this.gridData, coordinate, this.hexagonStorage)) : Optional.empty();
    }

    @Override
    public Optional<Hexagon> getByPixelCoordinate(double coordinateX, double coordinateY) {
        Hexagon trueHex;
        int estimatedGridX = (int)(coordinateX / this.gridData.getHexagonWidth());
        int estimatedGridZ = (int)(coordinateY / this.gridData.getHexagonHeight());
        AxialCoordinate estimatedCoordinate = AxialCoordinate.fromCoordinates(estimatedGridX = CoordinateConverter.convertOffsetCoordinatesToAxialX(estimatedGridX, estimatedGridZ, this.gridData.getOrientation()), estimatedGridZ = CoordinateConverter.convertOffsetCoordinatesToAxialZ(estimatedGridX, estimatedGridZ, this.gridData.getOrientation()));
        Hexagon tempHex = HexagonImpl.newHexagon(this.gridData, estimatedCoordinate, this.hexagonStorage);
        if (HexagonalGridImpl.hexagonsAreAtTheSamePosition(tempHex, trueHex = this.refineHexagonByPixel(tempHex, Point.fromPosition(coordinateX, coordinateY)))) {
            return this.getByAxialCoordinate(estimatedCoordinate);
        }
        return this.containsAxialCoordinate(trueHex.getAxialCoordinate()) ? Optional.of(trueHex) : Optional.empty();
    }

    @Override
    public Collection<Hexagon> getNeighborsOf(Hexagon hexagon) {
        HashSet<Hexagon> neighbors = new HashSet<Hexagon>();
        for (int[] neighbor : NEIGHBORS) {
            int neighborGridZ;
            int neighborGridX = hexagon.getGridX() + neighbor[0];
            AxialCoordinate neighborCoordinate = AxialCoordinate.fromCoordinates(neighborGridX, neighborGridZ = hexagon.getGridZ() + neighbor[1]);
            if (!this.containsAxialCoordinate(neighborCoordinate)) continue;
            Hexagon retHex = this.getByAxialCoordinate(neighborCoordinate).get();
            neighbors.add(retHex);
        }
        return neighbors;
    }

    @Override
    public void clearSatelliteData() {
        this.hexagonStorage.clear();
    }

    @Override
    public GridData getGridData() {
        return this.gridData;
    }

    private static boolean hexagonsAreAtTheSamePosition(Hexagon hex0, Hexagon hex1) {
        return hex0.getGridX() == hex1.getGridX() && hex0.getGridZ() == hex1.getGridZ();
    }

    private Hexagon refineHexagonByPixel(Hexagon hexagon, Point clickedPoint) {
        Hexagon refined = hexagon;
        double smallestDistance = clickedPoint.distanceFrom(Point.fromPosition(refined.getCenterX(), refined.getCenterY()));
        for (Hexagon neighbor : this.getNeighborsOf(hexagon)) {
            double currentDistance = clickedPoint.distanceFrom(Point.fromPosition(neighbor.getCenterX(), neighbor.getCenterY()));
            if (!(currentDistance < smallestDistance)) continue;
            refined = neighbor;
            smallestDistance = currentDistance;
        }
        return refined;
    }

    public Map<AxialCoordinate, Object> getHexagonStorage() {
        return this.hexagonStorage;
    }

    public Set<AxialCoordinate> getCoordinates() {
        return this.coordinates;
    }
}

