/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.internal.impl.layoutstrategy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.codetome.hexameter.core.api.AxialCoordinate;
import org.codetome.hexameter.core.api.HexagonOrientation;
import org.codetome.hexameter.core.api.HexagonalGridBuilder;
import org.codetome.hexameter.core.internal.impl.layoutstrategy.GridLayoutStrategy;
import rx.Observable;
import rx.Subscriber;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
public final class HexagonalGridLayoutStrategy
extends GridLayoutStrategy {
    @Override
    public Observable<AxialCoordinate> fetchGridCoordinates(final HexagonalGridBuilder builder) {
        Observable result = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<AxialCoordinate>(){

            public void call(Subscriber<? super AxialCoordinate> subscriber) {
                double gridSize = builder.getGridHeight();
                int startX = HexagonOrientation.FLAT_TOP.equals((Object)builder.getOrientation()) ? (int)Math.floor(gridSize / 2.0) : (int)Math.round(gridSize / 4.0);
                int hexRadius = (int)Math.floor(gridSize / 2.0);
                int minX = startX - hexRadius;
                int y = 0;
                while ((double)y < gridSize) {
                    int distanceFromMid = Math.abs(hexRadius - y);
                    for (int x = Math.max(startX, minX); x <= Math.max(startX, minX) + hexRadius + hexRadius - distanceFromMid; ++x) {
                        int gridX = x;
                        int gridZ = HexagonOrientation.FLAT_TOP.equals((Object)builder.getOrientation()) ? y - (int)Math.floor(gridSize / 4.0) : y;
                        subscriber.onNext((Object)AxialCoordinate.fromCoordinates(gridX, gridZ));
                    }
                    --startX;
                    ++y;
                }
                subscriber.onCompleted();
            }
        });
        return result;
    }

    @Override
    public boolean checkParameters(int gridHeight, int gridWidth) {
        boolean superResult = super.checkParameters(gridHeight, gridWidth);
        boolean result = gridHeight == gridWidth && Math.abs(gridHeight % 2) == 1;
        return result && superResult;
    }
}

