/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.internal.impl.layoutstrategy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.codetome.hexameter.core.api.AxialCoordinate;
import org.codetome.hexameter.core.api.CoordinateConverter;
import org.codetome.hexameter.core.api.HexagonalGridBuilder;
import org.codetome.hexameter.core.internal.impl.layoutstrategy.GridLayoutStrategy;
import rx.Observable;
import rx.Subscriber;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
public final class RectangularGridLayoutStrategy
extends GridLayoutStrategy {
    @Override
    public Observable<AxialCoordinate> fetchGridCoordinates(final HexagonalGridBuilder builder) {
        Observable result = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<AxialCoordinate>(){

            public void call(Subscriber<? super AxialCoordinate> subscriber) {
                for (int y = 0; y < builder.getGridHeight(); ++y) {
                    for (int x = 0; x < builder.getGridWidth(); ++x) {
                        int gridX = CoordinateConverter.convertOffsetCoordinatesToAxialX(x, y, builder.getOrientation());
                        int gridZ = CoordinateConverter.convertOffsetCoordinatesToAxialZ(x, y, builder.getOrientation());
                        subscriber.onNext((Object)AxialCoordinate.fromCoordinates(gridX, gridZ));
                    }
                }
                subscriber.onCompleted();
            }
        });
        return result;
    }

    @Override
    public boolean checkParameters(int gridHeight, int gridWidth) {
        return super.checkParameters(gridHeight, gridWidth);
    }
}

