/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.api;

import java.io.Serializable;
import java.util.Objects;

public final class CubeCoordinate
implements Serializable {
    public static final String SEP = ",";
    private static final long serialVersionUID = -6656555565645274603L;
    private final int gridX;
    private final int gridZ;

    private CubeCoordinate(int gridX, int gridZ) {
        this.gridX = gridX;
        this.gridZ = gridZ;
    }

    public static CubeCoordinate fromAxialKey(String axialKey) {
        CubeCoordinate result;
        try {
            String[] coords = axialKey.split(SEP);
            result = CubeCoordinate.fromCoordinates(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create CubeCoordinate from key: " + axialKey, e);
        }
        return result;
    }

    public static CubeCoordinate fromCoordinates(int gridX, int gridZ) {
        return new CubeCoordinate(gridX, gridZ);
    }

    public String toAxialKey() {
        return this.gridX + SEP + this.gridZ;
    }

    public int getGridY() {
        return -(this.getGridX() + this.getGridZ());
    }

    public int getGridX() {
        return this.gridX;
    }

    public int getGridZ() {
        return this.gridZ;
    }

    public int hashCode() {
        return Objects.hash(this.gridX, this.gridZ);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CubeCoordinate that = (CubeCoordinate)object;
        return this.gridX == that.gridX && this.gridZ == that.gridZ;
    }
}

