/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.api;

import org.codetome.hexameter.core.api.CubeCoordinate;

public enum RotationDirection {
    RIGHT(new RotationCalculator(){

        @Override
        public CubeCoordinate calculate(CubeCoordinate coord) {
            return CubeCoordinate.fromCoordinates(-coord.getGridZ(), -coord.getGridY());
        }
    }),
    LEFT(new RotationCalculator(){

        @Override
        public CubeCoordinate calculate(CubeCoordinate coord) {
            return CubeCoordinate.fromCoordinates(-coord.getGridY(), -coord.getGridX());
        }
    });

    private RotationCalculator rotationCalculator;

    private RotationDirection(RotationCalculator rotationCalculator) {
        this.rotationCalculator = rotationCalculator;
    }

    public CubeCoordinate calculateRotation(CubeCoordinate coord) {
        return this.rotationCalculator.calculate(coord);
    }

    static interface RotationCalculator {
        public CubeCoordinate calculate(CubeCoordinate var1);
    }
}

