/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.api.defaults;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codetome.hexameter.core.api.CubeCoordinate;
import org.codetome.hexameter.core.api.contract.HexagonDataStorage;
import org.codetome.hexameter.core.api.defaults.DefaultSatelliteData;
import org.codetome.hexameter.core.backport.Optional;
import rx.Observable;
import rx.Subscriber;

public class DefaultHexagonDataStorage
implements HexagonDataStorage<DefaultSatelliteData> {
    private Map<CubeCoordinate, Optional<DefaultSatelliteData>> storage = new LinkedHashMap<CubeCoordinate, Optional<DefaultSatelliteData>>();

    @Override
    public final void addCoordinate(CubeCoordinate cubeCoordinate) {
        this.storage.put(cubeCoordinate, Optional.empty());
    }

    @Override
    public final boolean addCoordinate(CubeCoordinate cubeCoordinate, DefaultSatelliteData satelliteData) {
        Optional<DefaultSatelliteData> previous = this.storage.put(cubeCoordinate, Optional.of(satelliteData));
        return previous != null;
    }

    @Override
    public final Optional<DefaultSatelliteData> getSatelliteDataBy(CubeCoordinate cubeCoordinate) {
        return this.storage.containsKey(cubeCoordinate) ? this.storage.get(cubeCoordinate) : Optional.empty();
    }

    @Override
    public final boolean containsCoordinate(CubeCoordinate cubeCoordinate) {
        return this.storage.containsKey(cubeCoordinate);
    }

    @Override
    public final boolean hasDataFor(CubeCoordinate cubeCoordinate) {
        return this.storage.containsKey(cubeCoordinate) && this.storage.get(cubeCoordinate).isPresent();
    }

    @Override
    public final Observable<CubeCoordinate> getCoordinates() {
        Observable result = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<CubeCoordinate>(){

            public void call(Subscriber<? super CubeCoordinate> subscriber) {
                Iterator coordinateIterator = DefaultHexagonDataStorage.this.storage.keySet().iterator();
                while (coordinateIterator.hasNext()) {
                    subscriber.onNext(coordinateIterator.next());
                }
                subscriber.onCompleted();
            }
        });
        return result;
    }

    @Override
    public final boolean clearDataFor(CubeCoordinate cubeCoordinate) {
        boolean result = false;
        if (this.hasDataFor(cubeCoordinate)) {
            result = true;
        }
        this.storage.put(cubeCoordinate, Optional.empty());
        return result;
    }
}

