/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.internal;

import org.codetome.hexameter.core.api.HexagonOrientation;
import org.codetome.hexameter.core.api.HexagonalGridLayout;

public final class GridData {
    private final HexagonOrientation orientation;
    private final HexagonalGridLayout gridLayout;
    private final double radius;
    private final double hexagonHeight;
    private final double hexagonWidth;
    private final int gridWidth;
    private final int gridHeight;

    public GridData(HexagonOrientation orientation, HexagonalGridLayout gridLayout, double radius, int gridWidth, int gridHeight) {
        this.orientation = orientation;
        this.gridLayout = gridLayout;
        this.radius = radius;
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.hexagonHeight = HexagonOrientation.FLAT_TOP.equals((Object)orientation) ? GridData.calculateHeight(radius) : GridData.calculateWidth(radius);
        this.hexagonWidth = HexagonOrientation.FLAT_TOP.equals((Object)orientation) ? GridData.calculateWidth(radius) : GridData.calculateHeight(radius);
    }

    private static double calculateHeight(double radius) {
        return Math.sqrt(3.0) * radius;
    }

    private static double calculateWidth(double radius) {
        return radius * 3.0 / 2.0;
    }

    public HexagonOrientation getOrientation() {
        return this.orientation;
    }

    public HexagonalGridLayout getGridLayout() {
        return this.gridLayout;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getHexagonHeight() {
        return this.hexagonHeight;
    }

    public double getHexagonWidth() {
        return this.hexagonWidth;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }
}

