/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.internal.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.codetome.hexameter.core.api.CubeCoordinate;
import org.codetome.hexameter.core.api.Hexagon;
import org.codetome.hexameter.core.api.HexagonOrientation;
import org.codetome.hexameter.core.api.Point;
import org.codetome.hexameter.core.api.contract.HexagonDataStorage;
import org.codetome.hexameter.core.api.contract.SatelliteData;
import org.codetome.hexameter.core.backport.Optional;
import org.codetome.hexameter.core.internal.GridData;

public class HexagonImpl<T extends SatelliteData>
implements Hexagon<T> {
    private final CubeCoordinate coordinate;
    private final transient GridData sharedData;
    private final transient HexagonDataStorage<T> hexagonDataStorage;

    public HexagonImpl(GridData gridData, CubeCoordinate coordinate, HexagonDataStorage<T> hexagonDataStorage) {
        this.sharedData = gridData;
        this.coordinate = coordinate;
        this.hexagonDataStorage = hexagonDataStorage;
    }

    @Override
    public final String getId() {
        return this.coordinate.toAxialKey();
    }

    public final List<Point> getPoints() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < 6; ++i) {
            double angle = 1.0471975511965976 * (double)((float)i + this.sharedData.getOrientation().getCoordinateOffset());
            double x = this.getCenterX() + this.sharedData.getRadius() * Math.cos(angle);
            double y = this.getCenterY() + this.sharedData.getRadius() * Math.sin(angle);
            points.add(Point.fromPosition(x, y));
        }
        return points;
    }

    @Override
    public final CubeCoordinate getCubeCoordinate() {
        return this.coordinate;
    }

    @Override
    public final int getGridX() {
        return this.coordinate.getGridX();
    }

    @Override
    public final int getGridY() {
        return this.coordinate.getGridY();
    }

    @Override
    public final int getGridZ() {
        return this.coordinate.getGridZ();
    }

    @Override
    public final double getCenterX() {
        if (HexagonOrientation.FLAT_TOP.equals((Object)this.sharedData.getOrientation())) {
            return (double)this.coordinate.getGridX() * this.sharedData.getHexagonWidth() + this.sharedData.getRadius();
        }
        return (double)this.coordinate.getGridX() * this.sharedData.getHexagonWidth() + (double)this.coordinate.getGridZ() * this.sharedData.getHexagonWidth() / 2.0 + this.sharedData.getHexagonWidth() / 2.0;
    }

    @Override
    public final double getCenterY() {
        if (HexagonOrientation.FLAT_TOP.equals((Object)this.sharedData.getOrientation())) {
            return (double)this.coordinate.getGridZ() * this.sharedData.getHexagonHeight() + (double)this.coordinate.getGridX() * this.sharedData.getHexagonHeight() / 2.0 + this.sharedData.getHexagonHeight() / 2.0;
        }
        return (double)this.coordinate.getGridZ() * this.sharedData.getHexagonHeight() + this.sharedData.getRadius();
    }

    @Override
    public final Optional<T> getSatelliteData() {
        return this.hexagonDataStorage.getSatelliteDataBy(this.getCubeCoordinate());
    }

    @Override
    public final void setSatelliteData(T satelliteData) {
        this.hexagonDataStorage.addCoordinate(this.getCubeCoordinate(), satelliteData);
    }

    @Override
    public final void clearSatelliteData() {
        this.hexagonDataStorage.clearDataFor(this.getCubeCoordinate());
    }

    public final int hashCode() {
        return Objects.hash(this.coordinate);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HexagonImpl hexagon = (HexagonImpl)object;
        return Objects.equals(this.coordinate, hexagon.coordinate);
    }
}

