/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.internal.impl;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.codetome.hexameter.core.api.CubeCoordinate;
import org.codetome.hexameter.core.api.Hexagon;
import org.codetome.hexameter.core.api.HexagonalGrid;
import org.codetome.hexameter.core.api.HexagonalGridCalculator;
import org.codetome.hexameter.core.api.RotationDirection;
import org.codetome.hexameter.core.api.contract.SatelliteData;
import org.codetome.hexameter.core.backport.Optional;

public final class HexagonalGridCalculatorImpl<T extends SatelliteData>
implements HexagonalGridCalculator<T> {
    private final HexagonalGrid<T> hexagonalGrid;

    public HexagonalGridCalculatorImpl(HexagonalGrid hexagonalGrid) {
        this.hexagonalGrid = hexagonalGrid;
    }

    @Override
    public int calculateDistanceBetween(Hexagon hex0, Hexagon hex1) {
        double absX = Math.abs(hex0.getGridX() - hex1.getGridX());
        double absY = Math.abs(hex0.getGridY() - hex1.getGridY());
        double absZ = Math.abs(hex0.getGridZ() - hex1.getGridZ());
        return (int)Math.max(Math.max(absX, absY), absZ);
    }

    @Override
    public Set<Hexagon<T>> calculateMovementRangeFrom(Hexagon<T> hexagon, int distance) {
        HashSet<Hexagon<T>> ret = new HashSet<Hexagon<T>>();
        for (int x = -distance; x <= distance; ++x) {
            for (int y = Math.max(-distance, -x - distance); y <= Math.min(distance, -x + distance); ++y) {
                int tmpZ;
                int z = -x - y;
                int tmpX = hexagon.getGridX() + x;
                CubeCoordinate tempCoordinate = CubeCoordinate.fromCoordinates(tmpX, tmpZ = hexagon.getGridZ() + z);
                if (!this.hexagonalGrid.containsCubeCoordinate(tempCoordinate)) continue;
                Hexagon<T> hex = this.hexagonalGrid.getByCubeCoordinate(tempCoordinate).get();
                ret.add(hex);
            }
        }
        return ret;
    }

    @Override
    public Optional<Hexagon<T>> rotateHexagon(Hexagon<T> originalHex, Hexagon<T> targetHex, RotationDirection rotationDirection) {
        int diffX = targetHex.getGridX() - originalHex.getGridX();
        int diffZ = targetHex.getGridZ() - originalHex.getGridZ();
        CubeCoordinate diffCoord = CubeCoordinate.fromCoordinates(diffX, diffZ);
        CubeCoordinate rotatedCoord = rotationDirection.calculateRotation(diffCoord);
        CubeCoordinate resultCoord = CubeCoordinate.fromCoordinates(originalHex.getGridX() + rotatedCoord.getGridX(), originalHex.getGridZ() + rotatedCoord.getGridZ());
        return this.hexagonalGrid.getByCubeCoordinate(resultCoord);
    }

    @Override
    public Set<Hexagon<T>> calculateRingFrom(Hexagon<T> centerHexagon, int radius) {
        HashSet<Hexagon<T>> result = new HashSet<Hexagon<T>>();
        boolean neighborIndex = false;
        Hexagon<T> currentHexagon = centerHexagon;
        for (int i = 0; i < radius; ++i) {
            Optional<Hexagon<T>> neighbor = this.hexagonalGrid.getNeighborByIndex(currentHexagon, 0);
            if (!neighbor.isPresent()) {
                return result;
            }
            currentHexagon = neighbor.get();
        }
        return result;
    }

    @Override
    public List<Hexagon<T>> drawLine(Hexagon<T> from, Hexagon<T> to) {
        int distance = this.calculateDistanceBetween((Hexagon)from, (Hexagon)to);
        LinkedList<Hexagon<T>> results = new LinkedList<Hexagon<T>>();
        if (distance == 0) {
            return results;
        }
        for (int i = 0; i <= distance; ++i) {
            CubeCoordinate interpolatedCoordinate = this.cubeLinearInterpolate(from.getCubeCoordinate(), to.getCubeCoordinate(), 1.0 / (double)distance * (double)i);
            results.add(this.hexagonalGrid.getByCubeCoordinate(interpolatedCoordinate).get());
        }
        return results;
    }

    @Override
    public boolean isVisible(Hexagon<T> from, Hexagon<T> to) {
        List<Hexagon<T>> traversePath = this.drawLine(from, to);
        for (Hexagon<T> pathHexagon : traversePath) {
            if (pathHexagon.equals(from) || pathHexagon.equals(to) || !pathHexagon.getSatelliteData().isPresent() || !((SatelliteData)pathHexagon.getSatelliteData().get()).isOpaque()) continue;
            return false;
        }
        return true;
    }

    private CubeCoordinate cubeLinearInterpolate(CubeCoordinate from, CubeCoordinate to, double sample) {
        return this.roundToCubeCoordinate(this.linearInterpolate(from.getGridX(), to.getGridX(), sample), this.linearInterpolate(from.getGridY(), to.getGridY(), sample), this.linearInterpolate(from.getGridZ(), to.getGridZ(), sample));
    }

    private double linearInterpolate(int from, int to, double sample) {
        return (double)from + (double)(to - from) * sample;
    }

    private CubeCoordinate roundToCubeCoordinate(double gridX, double gridY, double gridZ) {
        int rx = (int)Math.round(gridX);
        int ry = (int)Math.round(gridY);
        int rz = (int)Math.round(gridZ);
        double differenceX = Math.abs((double)rx - gridX);
        double differenceY = Math.abs((double)ry - gridY);
        double differenceZ = Math.abs((double)rz - gridZ);
        if (differenceX > differenceY && differenceX > differenceZ) {
            rx = -ry - rz;
        } else if (differenceY <= differenceZ) {
            rz = -rx - ry;
        }
        return CubeCoordinate.fromCoordinates(rx, rz);
    }
}

