/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.core.internal.impl;

import java.util.Collection;
import java.util.HashSet;
import org.codetome.hexameter.core.api.CoordinateConverter;
import org.codetome.hexameter.core.api.CubeCoordinate;
import org.codetome.hexameter.core.api.Hexagon;
import org.codetome.hexameter.core.api.HexagonalGrid;
import org.codetome.hexameter.core.api.HexagonalGridBuilder;
import org.codetome.hexameter.core.api.Point;
import org.codetome.hexameter.core.api.contract.HexagonDataStorage;
import org.codetome.hexameter.core.api.contract.SatelliteData;
import org.codetome.hexameter.core.backport.Optional;
import org.codetome.hexameter.core.internal.GridData;
import org.codetome.hexameter.core.internal.impl.HexagonImpl;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;

public final class HexagonalGridImpl<T extends SatelliteData>
implements HexagonalGrid<T> {
    private static final int[][] NEIGHBORS = new int[][]{{1, 0}, {1, -1}, {0, -1}, {-1, 0}, {-1, 1}, {0, 1}};
    private static final int NEIGHBOR_X_INDEX = 0;
    private static final int NEIGHBOR_Z_INDEX = 1;
    private final GridData gridData;
    private final HexagonDataStorage<T> hexagonDataStorage;

    public HexagonalGridImpl(HexagonalGridBuilder<T> builder) {
        this.gridData = builder.getGridData();
        this.hexagonDataStorage = builder.getHexagonDataStorage();
        builder.getGridLayoutStrategy().fetchGridCoordinates(builder).subscribe((Action1)new Action1<CubeCoordinate>(){

            public void call(CubeCoordinate cubeCoordinate) {
                HexagonalGridImpl.this.hexagonDataStorage.addCoordinate(cubeCoordinate);
            }
        });
    }

    @Override
    public GridData getGridData() {
        return this.gridData;
    }

    @Override
    public Observable<Hexagon<T>> getHexagons() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Hexagon<T>>(){

            public void call(final Subscriber<? super Hexagon<T>> subscriber) {
                HexagonalGridImpl.this.hexagonDataStorage.getCoordinates().subscribe((Subscriber)new Subscriber<CubeCoordinate>(){

                    public void onCompleted() {
                        subscriber.onCompleted();
                    }

                    public void onError(Throwable throwable) {
                        System.err.println(String.format("Cannot get Hexagons: <%s>", throwable.getMessage()));
                    }

                    public void onNext(CubeCoordinate cubeCoordinate) {
                        subscriber.onNext(new HexagonImpl(HexagonalGridImpl.this.gridData, cubeCoordinate, HexagonalGridImpl.this.hexagonDataStorage));
                    }
                });
            }
        });
    }

    @Override
    public Observable<Hexagon<T>> getHexagonsByCubeRange(final CubeCoordinate from, final CubeCoordinate to) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Hexagon<T>>(){

            public void call(Subscriber<? super Hexagon<T>> subscriber) {
                for (int gridZ = from.getGridZ(); gridZ <= to.getGridZ(); ++gridZ) {
                    for (int gridX = from.getGridX(); gridX <= to.getGridX(); ++gridX) {
                        CubeCoordinate currentCoordinate = CubeCoordinate.fromCoordinates(gridX, gridZ);
                        if (!HexagonalGridImpl.this.containsCubeCoordinate(currentCoordinate)) continue;
                        subscriber.onNext(HexagonalGridImpl.this.getByCubeCoordinate(currentCoordinate).get());
                    }
                }
                subscriber.onCompleted();
            }
        });
    }

    @Override
    public Observable<Hexagon<T>> getHexagonsByOffsetRange(final int gridXFrom, final int gridXTo, final int gridYFrom, final int gridYTo) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Hexagon<T>>(){

            public void call(Subscriber<? super Hexagon<T>> subscriber) {
                for (int gridX = gridXFrom; gridX <= gridXTo; ++gridX) {
                    for (int gridY = gridYFrom; gridY <= gridYTo; ++gridY) {
                        int cubeZ;
                        int cubeX = CoordinateConverter.convertOffsetCoordinatesToCubeX(gridX, gridY, HexagonalGridImpl.this.gridData.getOrientation());
                        CubeCoordinate cubeCoordinate = CubeCoordinate.fromCoordinates(cubeX, cubeZ = CoordinateConverter.convertOffsetCoordinatesToCubeZ(gridX, gridY, HexagonalGridImpl.this.gridData.getOrientation()));
                        Optional hexagon = HexagonalGridImpl.this.getByCubeCoordinate(cubeCoordinate);
                        if (!hexagon.isPresent()) continue;
                        subscriber.onNext(hexagon.get());
                    }
                }
                subscriber.onCompleted();
            }
        });
    }

    @Override
    public boolean containsCubeCoordinate(CubeCoordinate cubeCoordinate) {
        return this.hexagonDataStorage.containsCoordinate(cubeCoordinate);
    }

    @Override
    public Optional<Hexagon<T>> getByCubeCoordinate(CubeCoordinate coordinate) {
        return this.containsCubeCoordinate(coordinate) ? Optional.of(new HexagonImpl<T>(this.gridData, coordinate, this.hexagonDataStorage)) : Optional.empty();
    }

    @Override
    public Optional<Hexagon<T>> getByPixelCoordinate(double coordinateX, double coordinateY) {
        Hexagon<T> trueHex;
        int estimatedGridX = (int)(coordinateX / this.gridData.getHexagonWidth());
        int estimatedGridZ = (int)(coordinateY / this.gridData.getHexagonHeight());
        CubeCoordinate estimatedCoordinate = CubeCoordinate.fromCoordinates(estimatedGridX = CoordinateConverter.convertOffsetCoordinatesToCubeX(estimatedGridX, estimatedGridZ, this.gridData.getOrientation()), estimatedGridZ = CoordinateConverter.convertOffsetCoordinatesToCubeZ(estimatedGridX, estimatedGridZ, this.gridData.getOrientation()));
        HexagonImpl<T> tempHex = new HexagonImpl<T>(this.gridData, estimatedCoordinate, this.hexagonDataStorage);
        if (this.hexagonsAreAtTheSamePosition(tempHex, trueHex = this.refineHexagonByPixel(tempHex, Point.fromPosition(coordinateX, coordinateY)))) {
            return this.getByCubeCoordinate(estimatedCoordinate);
        }
        return this.containsCubeCoordinate(trueHex.getCubeCoordinate()) ? Optional.of(trueHex) : Optional.empty();
    }

    @Override
    public Optional<Hexagon<T>> getNeighborByIndex(Hexagon<T> hexagon, int index) {
        int neighborGridX = hexagon.getGridX() + NEIGHBORS[index][0];
        int neighborGridZ = hexagon.getGridZ() + NEIGHBORS[index][1];
        CubeCoordinate neighborCoordinate = CubeCoordinate.fromCoordinates(neighborGridX, neighborGridZ);
        return this.getByCubeCoordinate(neighborCoordinate);
    }

    @Override
    public Collection<Hexagon<T>> getNeighborsOf(Hexagon<T> hexagon) {
        HashSet<Hexagon<T>> neighbors = new HashSet<Hexagon<T>>();
        for (int i = 0; i < NEIGHBORS.length; ++i) {
            Optional<Hexagon<T>> retHex = this.getNeighborByIndex(hexagon, i);
            if (!retHex.isPresent()) continue;
            neighbors.add(retHex.get());
        }
        return neighbors;
    }

    private boolean hexagonsAreAtTheSamePosition(Hexagon<T> hex0, Hexagon<T> hex1) {
        return hex0.getGridX() == hex1.getGridX() && hex0.getGridZ() == hex1.getGridZ();
    }

    private Hexagon<T> refineHexagonByPixel(Hexagon<T> hexagon, Point clickedPoint) {
        Hexagon<T> refined = hexagon;
        double smallestDistance = clickedPoint.distanceFrom(Point.fromPosition(refined.getCenterX(), refined.getCenterY()));
        for (Hexagon<T> neighbor : this.getNeighborsOf(hexagon)) {
            double currentDistance = clickedPoint.distanceFrom(Point.fromPosition(neighbor.getCenterX(), neighbor.getCenterY()));
            if (!(currentDistance < smallestDistance)) continue;
            refined = neighbor;
            smallestDistance = currentDistance;
        }
        return refined;
    }
}

