/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.util;

import com.google.gson.GsonBuilder;
import org.codetome.hexameter.core.api.AxialCoordinate;
import org.codetome.hexameter.core.api.Hexagon;
import org.codetome.hexameter.core.api.HexagonalGrid;
import org.codetome.hexameter.core.api.HexagonalGridBuilder;
import org.codetome.hexameter.core.api.SatelliteData;
import org.codetome.hexameter.core.internal.SharedHexagonData;
import org.codetome.hexameter.core.internal.impl.HexagonalGridImpl;
import org.codetome.hexameter.util.MapData;
import org.codetome.hexameter.util.MapSatelliteData;

public final class MapUtil {
    public static String exportMap(HexagonalGrid grid, String name, String tilesetUrl) {
        MapData result = new MapData();
        HexagonalGridImpl hgi = (HexagonalGridImpl)grid;
        SharedHexagonData shd = hgi.getSharedHexagonData();
        result.setRadius(shd.getRadius());
        result.setWidth(hgi.getGridWidth());
        result.setHeight(hgi.getGridHeight());
        result.setLayout(hgi.getGridLayout());
        result.setOrientation(shd.getOrientation());
        result.setName(name);
        result.setTilesetUrl(tilesetUrl);
        result.setVersion("1.0.0");
        grid.getHexagons().forEach(hex -> {
            if (hex.getSatelliteData().isPresent()) {
                result.addCellData(MapUtil.extractCellData(hex));
            }
        });
        return new GsonBuilder().create().toJson((Object)result);
    }

    public static HexagonalGrid importMap(String mapJson) {
        MapData mapData = (MapData)new GsonBuilder().create().fromJson(mapJson, MapData.class);
        HexagonalGrid grid = new HexagonalGridBuilder().setGridHeight(mapData.getHeight()).setGridWidth(mapData.getWidth()).setRadius(mapData.getRadius()).setOrientation(mapData.getOrientation()).setGridLayout(mapData.getLayout()).build();
        mapData.getCells().forEach(cell -> {
            MapSatelliteData msd = new MapSatelliteData();
            msd.setTilesetId(cell[CellDataKeys.TILESET_ID.ordinal()]);
            msd.setMovementCost(Double.parseDouble(cell[CellDataKeys.MOVEMENT_COST.ordinal()]));
            msd.setPassable(!"0".equals(cell[CellDataKeys.IS_PASSABLE.ordinal()]));
            int gridX = Integer.parseInt(cell[CellDataKeys.GRID_X.ordinal()]);
            int gridZ = Integer.parseInt(cell[CellDataKeys.GRID_Z.ordinal()]);
            ((Hexagon)grid.getByAxialCoordinate(AxialCoordinate.fromCoordinates((int)gridX, (int)gridZ)).get()).setSatelliteData((SatelliteData)msd);
        });
        return grid;
    }

    private static String[] extractCellData(Hexagon hex) {
        MapSatelliteData sd = (MapSatelliteData)((Object)hex.getSatelliteData().get());
        String[] result = new String[5];
        result[CellDataKeys.GRID_X.ordinal()] = Integer.toString(hex.getGridX());
        result[CellDataKeys.GRID_Z.ordinal()] = Integer.toString(hex.getGridZ());
        result[CellDataKeys.IS_PASSABLE.ordinal()] = sd.isPassable() ? "1" : "0";
        result[CellDataKeys.MOVEMENT_COST.ordinal()] = Double.toString(sd.getMovementCost());
        result[CellDataKeys.TILESET_ID.ordinal()] = sd.getTilesetId();
        return result;
    }

    private static enum CellDataKeys {
        GRID_X,
        GRID_Z,
        IS_PASSABLE,
        MOVEMENT_COST,
        TILESET_ID;

    }
}

