/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.analyzer;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import opennlp.model.AbstractModel;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import org.apache.log4j.Logger;
import org.cogroo.analyzer.Analyzer;
import org.cogroo.analyzer.Chunker;
import org.cogroo.analyzer.ComponentFactoryI;
import org.cogroo.analyzer.ContractionFinder;
import org.cogroo.analyzer.Featurizer;
import org.cogroo.analyzer.HeadFinder;
import org.cogroo.analyzer.InitializationException;
import org.cogroo.analyzer.Lemmatizer;
import org.cogroo.analyzer.NameFinder;
import org.cogroo.analyzer.POSTagger;
import org.cogroo.analyzer.Pipe;
import org.cogroo.analyzer.SentenceDetector;
import org.cogroo.analyzer.ShallowParser;
import org.cogroo.analyzer.Tokenizer;
import org.cogroo.config.Analyzers;
import org.cogroo.config.LanguageConfiguration;
import org.cogroo.config.LanguageConfigurationUtil;
import org.cogroo.config.Model;
import org.cogroo.dictionary.LemmaDictionary;
import org.cogroo.dictionary.impl.FSADictionary;
import org.cogroo.tools.chunker2.ChunkerME;
import org.cogroo.tools.chunker2.ChunkerModel;
import org.cogroo.tools.featurizer.FeaturizerME;
import org.cogroo.tools.featurizer.FeaturizerModel;

public class ComponentFactory
implements ComponentFactoryI {
    protected static final Logger LOGGER = Logger.getLogger(ComponentFactory.class);
    private LanguageConfiguration lc = null;
    private Map<Analyzers, String> modelPathMap;

    private ComponentFactory() {
    }

    private ComponentFactory(LanguageConfiguration lc) {
        this.lc = lc;
        this.modelPathMap = new HashMap<Analyzers, String>(lc.getModel().size());
        for (Model m : lc.getModel()) {
            this.modelPathMap.put(m.getType(), m.getValue());
        }
    }

    public static ComponentFactory create(Locale locale) {
        ComponentFactory factory = null;
        factory = new ComponentFactory(LanguageConfigurationUtil.get(locale));
        return factory;
    }

    public static ComponentFactory create(InputStream configuration) {
        ComponentFactory factory = null;
        factory = new ComponentFactory(LanguageConfigurationUtil.get(configuration));
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Analyzer createSentenceDetector() {
        SentenceDetector analyzer;
        long start;
        block6: {
            start = System.nanoTime();
            SentenceDetectorME sentenceDetector = null;
            InputStream modelIn = null;
            analyzer = null;
            if (!this.modelPathMap.containsKey((Object)Analyzers.SENTENCE_DETECTOR)) break block6;
            try {
                modelIn = ComponentFactory.class.getResourceAsStream(this.modelPathMap.get((Object)Analyzers.SENTENCE_DETECTOR));
                SentenceModel model = new SentenceModel(modelIn);
                sentenceDetector = new SentenceDetectorME(model);
            }
            catch (IOException e) {
                try {
                    LOGGER.fatal((Object)"Couldn't load sentence model!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(modelIn);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)modelIn);
            }
            Closeables.closeQuietly((Closeable)modelIn);
            if (sentenceDetector == null) {
                throw new InitializationException("Couldn't load SentenceDetectorME class");
            }
            analyzer = new SentenceDetector(sentenceDetector);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Initialized SentenceDetector in " + (System.nanoTime() - start) / 1000000L + "ms]"));
        }
        return analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Analyzer createTokenizer() {
        Tokenizer analyzer;
        long start;
        block6: {
            start = System.nanoTime();
            analyzer = null;
            TokenizerME tokenizer = null;
            InputStream modelIn = null;
            if (!this.modelPathMap.containsKey((Object)Analyzers.TOKENIZER)) break block6;
            try {
                modelIn = ComponentFactory.class.getResourceAsStream(this.modelPathMap.get((Object)Analyzers.TOKENIZER));
                TokenizerModel model = new TokenizerModel(modelIn);
                tokenizer = new TokenizerME(model);
            }
            catch (IOException e) {
                try {
                    LOGGER.fatal((Object)"Couldn't load tokenizer model!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(modelIn);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)modelIn);
            }
            Closeables.closeQuietly((Closeable)modelIn);
            if (tokenizer == null) {
                throw new InitializationException("Couldn't load TokenizerME class");
            }
            analyzer = new Tokenizer(tokenizer);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Initialized Tokenizer in " + (System.nanoTime() - start) / 1000000L + "ms]"));
        }
        return analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Analyzer createNameFinder() {
        NameFinder analyzer;
        long start;
        block6: {
            start = System.nanoTime();
            analyzer = null;
            NameFinderME nameFinder = null;
            InputStream modelIn = null;
            if (!this.modelPathMap.containsKey((Object)Analyzers.NAME_FINDER)) break block6;
            try {
                modelIn = ComponentFactory.class.getResourceAsStream(this.modelPathMap.get((Object)Analyzers.NAME_FINDER));
                TokenNameFinderModel model = new TokenNameFinderModel(modelIn);
                nameFinder = new NameFinderME(model);
            }
            catch (IOException e) {
                try {
                    LOGGER.fatal((Object)"Couldn't load name finder model!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(modelIn);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)modelIn);
            }
            Closeables.closeQuietly((Closeable)modelIn);
            if (nameFinder == null) {
                throw new InitializationException("Couldn't load NameFinderME class");
            }
            analyzer = new NameFinder(nameFinder);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Initialized NameFinder in " + (System.nanoTime() - start) / 1000000L + "ms]"));
        }
        return analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Analyzer createContractionFinder() {
        ContractionFinder analyzer;
        long start;
        block6: {
            start = System.nanoTime();
            analyzer = null;
            NameFinderME contractionFinder = null;
            InputStream modelIn = null;
            if (!this.modelPathMap.containsKey((Object)Analyzers.CONTRACTION_FINDER)) break block6;
            try {
                modelIn = ComponentFactory.class.getResourceAsStream(this.modelPathMap.get((Object)Analyzers.CONTRACTION_FINDER));
                TokenNameFinderModel model = new TokenNameFinderModel(modelIn);
                contractionFinder = new NameFinderME(model);
            }
            catch (IOException e) {
                try {
                    LOGGER.fatal((Object)"Couldn't load contractions finder model!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(modelIn);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)modelIn);
            }
            Closeables.closeQuietly((Closeable)modelIn);
            if (contractionFinder == null) {
                throw new InitializationException("Couldn't load NameFinderME class");
            }
            analyzer = new ContractionFinder(contractionFinder);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Initialized ContractionFinder in " + (System.nanoTime() - start) / 1000000L + "ms]"));
        }
        return analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Analyzer createPOSTagger() {
        POSTagger analyzer;
        long start;
        block6: {
            start = System.nanoTime();
            analyzer = null;
            POSTaggerME tagger = null;
            InputStream modelIn = null;
            if (!this.modelPathMap.containsKey((Object)Analyzers.POS_TAGGER)) break block6;
            try {
                modelIn = ComponentFactory.class.getResourceAsStream(this.modelPathMap.get((Object)Analyzers.POS_TAGGER));
                POSModel model = new POSModel(modelIn);
                tagger = new POSTaggerME(model);
            }
            catch (IOException e) {
                try {
                    LOGGER.fatal((Object)"Couldn't load POS-tagger model!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(modelIn);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)modelIn);
            }
            Closeables.closeQuietly((Closeable)modelIn);
            if (tagger == null) {
                throw new InitializationException("Couldn't load POSTaggerME class");
            }
            analyzer = new POSTagger(tagger);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Initialized POSTagger in " + (System.nanoTime() - start) / 1000000L + "ms]"));
        }
        return analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Analyzer createFeaturizer() {
        Featurizer analyzer;
        long start;
        block6: {
            start = System.nanoTime();
            analyzer = null;
            FeaturizerME featurizer = null;
            InputStream modelIn = null;
            if (!this.modelPathMap.containsKey((Object)Analyzers.FEATURIZER)) break block6;
            try {
                modelIn = ComponentFactory.class.getResourceAsStream(this.modelPathMap.get((Object)Analyzers.FEATURIZER));
                FeaturizerModel model = new FeaturizerModel(modelIn);
                featurizer = new FeaturizerME(model);
            }
            catch (IOException e) {
                try {
                    LOGGER.fatal((Object)"Couldn't load Featurizer model!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(modelIn);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)modelIn);
            }
            Closeables.closeQuietly((Closeable)modelIn);
            if (featurizer == null) {
                throw new InitializationException("Couldn't load FeaturizerME class");
            }
            analyzer = new Featurizer(featurizer);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Initialized Featurizer in " + (System.nanoTime() - start) / 1000000L + "ms]"));
        }
        return analyzer;
    }

    public Analyzer createLemmatizer() {
        long start = System.nanoTime();
        Lemmatizer analyzer = null;
        try {
            Lemmatizer lemmatizer;
            FSADictionary dict = FSADictionary.createFromResources((String)"/fsa_dictionaries/pos/pt_br_jspell.dict");
            analyzer = lemmatizer = new Lemmatizer((LemmaDictionary)dict);
        }
        catch (IllegalArgumentException e) {
            LOGGER.fatal((Object)"Couldn't load ");
            throw new InitializationException("Couldn't load", e);
        }
        catch (IOException e) {
            LOGGER.fatal((Object)"Couldn't find the dictionary.");
            throw new InitializationException("Couldn't locate dictionary", e);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Initialized Lemmatizer in " + (System.nanoTime() - start) / 1000000L + "ms]"));
        }
        return analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Analyzer createChunker() {
        Chunker analyzer;
        long start;
        block6: {
            start = System.nanoTime();
            analyzer = null;
            ChunkerME chunker = null;
            InputStream modelIn = null;
            if (!this.modelPathMap.containsKey((Object)Analyzers.CHUNKER)) break block6;
            try {
                modelIn = ComponentFactory.class.getResourceAsStream(this.modelPathMap.get((Object)Analyzers.CHUNKER));
                ChunkerModel model = new ChunkerModel(modelIn);
                chunker = new ChunkerME(model);
            }
            catch (IOException e) {
                try {
                    LOGGER.fatal((Object)"Couldn't load Chunker model!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(modelIn);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)modelIn);
            }
            Closeables.closeQuietly((Closeable)modelIn);
            if (chunker == null) {
                throw new InitializationException("Couldn't load ChunkerME class");
            }
            analyzer = new Chunker(chunker);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Initialized Chunker in " + (System.nanoTime() - start) / 1000000L + "ms]"));
        }
        return analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Analyzer createHeadFinder() {
        HeadFinder analyzer;
        long start;
        block6: {
            start = System.nanoTime();
            analyzer = null;
            ChunkerME headFinder = null;
            InputStream modelIn = null;
            if (!this.modelPathMap.containsKey((Object)Analyzers.HEAD_FINDER)) break block6;
            try {
                modelIn = ComponentFactory.class.getResourceAsStream(this.modelPathMap.get((Object)Analyzers.HEAD_FINDER));
                ChunkerModel model = new ChunkerModel(modelIn);
                headFinder = new ChunkerME(model);
            }
            catch (IOException e) {
                try {
                    LOGGER.fatal((Object)"Couldn't load HeadFinder model!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(modelIn);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)modelIn);
            }
            Closeables.closeQuietly((Closeable)modelIn);
            if (headFinder == null) {
                throw new InitializationException("Couldn't load ChunkerME class");
            }
            analyzer = new HeadFinder(headFinder);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Initialized HeadFinder in " + (System.nanoTime() - start) / 1000000L + "ms]"));
        }
        return analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Analyzer createShallowParser() {
        ShallowParser analyzer;
        long start;
        block6: {
            start = System.nanoTime();
            analyzer = null;
            ChunkerME shallowParser = null;
            InputStream modelIn = null;
            if (!this.modelPathMap.containsKey((Object)Analyzers.SHALLOW_PARSER)) break block6;
            try {
                modelIn = ComponentFactory.class.getResourceAsStream(this.modelPathMap.get((Object)Analyzers.SHALLOW_PARSER));
                ChunkerModel model = new ChunkerModel(modelIn);
                this.logOutcomes(model.getChunkerModel());
                shallowParser = new ChunkerME(model, 20);
            }
            catch (IOException e) {
                try {
                    LOGGER.fatal((Object)"Couldn't load ShallowParser model!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(modelIn);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)modelIn);
            }
            Closeables.closeQuietly((Closeable)modelIn);
            if (shallowParser == null) {
                throw new InitializationException("Couldn't load ChunkerME class");
            }
            analyzer = new ShallowParser(shallowParser);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Initialized ShallowParser in " + (System.nanoTime() - start) / 1000000L + "ms]"));
        }
        return analyzer;
    }

    private void logOutcomes(AbstractModel chunkerModel) {
        StringBuilder sb = new StringBuilder("Outcomes: ");
        for (int i = 0; i < chunkerModel.getNumOutcomes(); ++i) {
            sb.append(chunkerModel.getOutcome(i)).append(" ");
        }
        LOGGER.info((Object)sb.toString());
    }

    @Override
    public Analyzer createPipe() {
        long start = System.nanoTime();
        Pipe pipe = new Pipe();
        LinkedList<FutureTask<Analyzer>> initializers = new LinkedList<FutureTask<Analyzer>>();
        ExecutorService executor = Executors.newCachedThreadPool();
        LOGGER.info((Object)"Loading pipe assynchronously...");
        block15: for (Analyzers analyzers : this.lc.getPipe().getAnalyzer()) {
            switch (analyzers) {
                case SENTENCE_DETECTOR: {
                    FutureTask<Analyzer> future = new FutureTask<Analyzer>(new Callable<Analyzer>(){

                        @Override
                        public Analyzer call() {
                            return ComponentFactory.this.createSentenceDetector();
                        }
                    });
                    executor.execute(future);
                    initializers.add(future);
                    continue block15;
                }
                case TOKENIZER: {
                    FutureTask<Analyzer> future = new FutureTask<Analyzer>(new Callable<Analyzer>(){

                        @Override
                        public Analyzer call() {
                            return ComponentFactory.this.createTokenizer();
                        }
                    });
                    executor.execute(future);
                    initializers.add(future);
                    continue block15;
                }
                case NAME_FINDER: {
                    FutureTask<Analyzer> future = new FutureTask<Analyzer>(new Callable<Analyzer>(){

                        @Override
                        public Analyzer call() {
                            return ComponentFactory.this.createNameFinder();
                        }
                    });
                    executor.execute(future);
                    initializers.add(future);
                    continue block15;
                }
                case CONTRACTION_FINDER: {
                    FutureTask<Analyzer> future = new FutureTask<Analyzer>(new Callable<Analyzer>(){

                        @Override
                        public Analyzer call() {
                            return ComponentFactory.this.createContractionFinder();
                        }
                    });
                    executor.execute(future);
                    initializers.add(future);
                    continue block15;
                }
                case POS_TAGGER: {
                    FutureTask<Analyzer> future = new FutureTask<Analyzer>(new Callable<Analyzer>(){

                        @Override
                        public Analyzer call() {
                            return ComponentFactory.this.createPOSTagger();
                        }
                    });
                    executor.execute(future);
                    initializers.add(future);
                    continue block15;
                }
                case FEATURIZER: {
                    FutureTask<Analyzer> future = new FutureTask<Analyzer>(new Callable<Analyzer>(){

                        @Override
                        public Analyzer call() {
                            return ComponentFactory.this.createFeaturizer();
                        }
                    });
                    executor.execute(future);
                    initializers.add(future);
                    continue block15;
                }
                case LEMMATIZER: {
                    FutureTask<Analyzer> future = new FutureTask<Analyzer>(new Callable<Analyzer>(){

                        @Override
                        public Analyzer call() {
                            return ComponentFactory.this.createLemmatizer();
                        }
                    });
                    executor.execute(future);
                    initializers.add(future);
                    continue block15;
                }
                case CHUNKER: {
                    FutureTask<Analyzer> future = new FutureTask<Analyzer>(new Callable<Analyzer>(){

                        @Override
                        public Analyzer call() {
                            return ComponentFactory.this.createChunker();
                        }
                    });
                    executor.execute(future);
                    initializers.add(future);
                    continue block15;
                }
                case HEAD_FINDER: {
                    FutureTask<Analyzer> future = new FutureTask<Analyzer>(new Callable<Analyzer>(){

                        @Override
                        public Analyzer call() {
                            return ComponentFactory.this.createHeadFinder();
                        }
                    });
                    executor.execute(future);
                    initializers.add(future);
                    continue block15;
                }
                case SHALLOW_PARSER: {
                    FutureTask<Analyzer> future = new FutureTask<Analyzer>(new Callable<Analyzer>(){

                        @Override
                        public Analyzer call() {
                            return ComponentFactory.this.createShallowParser();
                        }
                    });
                    executor.execute(future);
                    initializers.add(future);
                    continue block15;
                }
            }
            throw new InitializationException("Unknown analyzer: " + (Object)((Object)analyzers));
        }
        for (FutureTask futureTask : initializers) {
            try {
                pipe.add((Analyzer)futureTask.get());
            }
            catch (InterruptedException e) {
                throw new InitializationException("Failed to load pipe.", e);
            }
            catch (ExecutionException e) {
                throw new InitializationException("Failed to load pipe.", e);
            }
        }
        executor.shutdown();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Initialized Pipe and its components in " + (System.nanoTime() - start) / 1000000L + "ms]"));
        }
        return pipe;
    }
}

