/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.text.impl;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.Span;
import org.cogroo.config.Analyzers;
import org.cogroo.text.Token;

public class TokenImpl
implements Token {
    private Span span;
    private String lexeme;
    private String[] lemmas;
    private String posTag;
    private String features;
    private String chunkTag;
    private String syntacticTag;
    private Map<Analyzers, String> additionalContext = new HashMap<Analyzers, String>();
    private double posTagProb;
    private boolean isChunkHead;

    public TokenImpl(int start, int end, String lexeme) {
        this(start, end, lexeme, null, null, null);
    }

    public TokenImpl(int start, int end, String lexeme, String[] lemmas, String tag, String features) {
        this.span = new Span(start, end);
        this.lexeme = lexeme;
        this.lemmas = lemmas;
        this.posTag = tag;
        this.features = features;
    }

    @Override
    public String[] getLemmas() {
        return this.lemmas;
    }

    @Override
    public void setLemmas(String[] lemmas) {
        this.lemmas = lemmas;
    }

    @Override
    public String getLexeme() {
        return this.lexeme;
    }

    @Override
    public void setLexeme(String lexeme) {
        this.lexeme = lexeme;
    }

    @Override
    public String getPOSTag() {
        return this.posTag;
    }

    @Override
    public void setPOSTag(String tag) {
        this.posTag = tag;
    }

    @Override
    public void setFeatures(String features) {
        this.features = features;
    }

    @Override
    public String getFeatures() {
        return this.features;
    }

    @Override
    public String getChunkTag() {
        return this.chunkTag;
    }

    @Override
    public void setChunkTag(String chunkTag) {
        this.chunkTag = chunkTag;
    }

    @Override
    public void setSyntacticTag(String tag) {
        this.syntacticTag = tag;
    }

    @Override
    public String getSyntacticTag() {
        return this.syntacticTag;
    }

    @Override
    public void addContext(Analyzers analyzer, String value) {
        this.additionalContext.put(analyzer, value);
    }

    @Override
    public String getAdditionalContext(Analyzers analyzer) {
        return this.additionalContext.get((Object)analyzer);
    }

    public String[] lexemesToString(List<Token> tokens) {
        String[] lexemes = new String[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            lexemes[i] = tokens.get(i).getLexeme();
        }
        return lexemes;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TokenImpl) {
            TokenImpl that = (TokenImpl)obj;
            return Objects.equal((Object)this.lexeme, (Object)that.lexeme) && Objects.equal((Object)this.lemmas, (Object)that.lemmas) && Objects.equal((Object)this.span, (Object)that.span);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("lxm", (Object)this.lexeme).add("lm", (Object)Arrays.toString(this.lemmas)).add("posTag", (Object)this.posTag).add("feat", (Object)this.features).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.lexeme, this.lemmas, this.span});
    }

    @Override
    public int getStart() {
        return this.span.getStart();
    }

    @Override
    public int getEnd() {
        return this.span.getEnd();
    }

    @Override
    public void setBoundaries(int start, int end) {
        this.span = new Span(start, end);
    }

    @Override
    public double getPOSTagProb() {
        return this.posTagProb;
    }

    @Override
    public void setPOSTagProb(double prob) {
        this.posTagProb = prob;
    }

    @Override
    public boolean isChunkHead() {
        return this.isChunkHead;
    }

    @Override
    public void isChunkHead(boolean ch) {
        this.isChunkHead = ch;
    }
}

