/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.text.tree;

import com.google.common.base.Joiner;
import org.cogroo.text.tree.TreeElement;

public class Leaf
extends TreeElement {
    private String word;
    private String[] lemma;

    public Leaf(String word, String[] lemma) {
        this.word = word;
        this.lemma = lemma;
    }

    public void setLexeme(String lexeme) {
        this.word = lexeme;
    }

    public String getLexeme() {
        return this.word;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.getLevel(); ++i) {
            sb.append("=");
        }
        if (this.getSyntacticTag() != null) {
            sb.append(this.getSyntacticTag() + "(" + this.getMorphologicalTag() + ") ");
        }
        sb.append(this.word + "\n");
        return sb.toString();
    }

    public void setLemma(String[] lemma) {
        this.lemma = lemma;
    }

    public String[] getLemma() {
        return this.lemma;
    }

    @Override
    public String toSyntaxTree() {
        return "[" + this.getMorphologicalTag() + " " + this.word + "]";
    }

    @Override
    public String toTreebank() {
        return "(" + this.createTag() + " " + this.word + ")";
    }

    private String createTag() {
        boolean hasFeats;
        boolean hasLemma = this.getLemma() != null && this.getLemma().length > 0;
        boolean bl = hasFeats = this.getFeatureTag() != null && !this.getFeatureTag().equals("-");
        if (this.getLexeme().equals(this.getMorphologicalTag())) {
            return "PUNCT";
        }
        StringBuilder sb = new StringBuilder(this.getMorphologicalTag().replace("-", ""));
        if (hasLemma || hasFeats) {
            sb.append("-");
            if (hasFeats) {
                sb.append(this.getFeatureTag());
            } else {
                sb.append("*");
            }
            if (hasLemma) {
                sb.append("-");
                sb.append(Joiner.on((char)'|').join((Object[])this.getLemma()));
            }
        }
        return sb.toString();
    }
}

