/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.text.impl;

import java.util.Collections;
import java.util.List;
import opennlp.tools.util.Span;
import org.cogroo.text.Chunk;
import org.cogroo.text.Sentence;
import org.cogroo.text.Token;

public class ChunkImpl
implements Chunk {
    private Span span;
    private Sentence theSentence;
    private int index = -1;
    private String tag;

    public ChunkImpl(String tag, int start, int end, Sentence theSentence) {
        this.tag = tag;
        this.span = new Span(start, end);
        this.theSentence = theSentence;
    }

    public String toString() {
        List<Token> tokens = this.theSentence.getTokens();
        StringBuilder sentence = new StringBuilder();
        sentence.append("Chunk: ").append(this.tag).append(" [ ");
        for (int i = this.span.getStart(); i < this.span.getEnd(); ++i) {
            if (i == this.index) {
                sentence.append("*");
            }
            sentence.append(tokens.get(i).getLexeme()).append(" ");
        }
        sentence.append("]\n");
        return sentence.toString();
    }

    @Override
    public void setHeadIndex(int index) {
        this.index = index;
    }

    @Override
    public int getHeadIndex() {
        return this.index;
    }

    @Override
    public int getStart() {
        return this.span.getStart();
    }

    @Override
    public int getEnd() {
        return this.span.getEnd();
    }

    @Override
    public void setBoundaries(int start, int end) {
        this.span = new Span(start, end);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public List<Token> getTokens() {
        return Collections.unmodifiableList(this.theSentence.getTokens().subList(this.getStart(), this.getEnd()));
    }
}

