/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.analyzer;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.util.Span;
import org.cogroo.analyzer.Analyzer;
import org.cogroo.text.Document;
import org.cogroo.text.Sentence;
import org.cogroo.text.SyntacticChunk;
import org.cogroo.text.Token;
import org.cogroo.text.impl.SyntacticChunkImpl;
import org.cogroo.util.TextUtils;

public class ShallowParser
implements Analyzer {
    private ChunkerME shallowParser;

    public ShallowParser(ChunkerME shallowParser) {
        this.shallowParser = shallowParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(Document document) {
        List<Sentence> sentences = document.getSentences();
        for (Sentence sentence : sentences) {
            Span[] spSpans;
            List<Token> tokens = sentence.getTokens();
            ArrayList<SyntacticChunk> syntChunks = new ArrayList<SyntacticChunk>();
            String[] tags = new String[tokens.size()];
            for (int i = 0; i < tokens.size(); ++i) {
                tags[i] = tokens.get(i).getPOSTag() + "|" + tokens.get(i).getChunkTag();
            }
            String[] tokensString = TextUtils.tokensToString(tokens);
            String[] spTags = null;
            ChunkerME chunkerME = this.shallowParser;
            synchronized (chunkerME) {
                spTags = this.shallowParser.chunk(tokensString, tags);
            }
            for (int i = 0; i < spTags.length; ++i) {
                tokens.get(i).setSyntacticTag(spTags[i]);
            }
            for (Span span : spSpans = ChunkSample.phrasesAsSpanList((String[])tokensString, (String[])tags, (String[])spTags)) {
                SyntacticChunkImpl st = new SyntacticChunkImpl(span.getType(), span.getStart(), span.getEnd(), sentence);
                syntChunks.add(st);
            }
            sentence.setSyntacticChunks(syntChunks);
        }
    }
}

