/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.text.impl;

import java.util.Collections;
import java.util.List;
import opennlp.tools.util.Span;
import org.cogroo.text.Sentence;
import org.cogroo.text.SyntacticChunk;
import org.cogroo.text.Token;

public class SyntacticChunkImpl
implements SyntacticChunk {
    private Span span;
    private Sentence theSentence;
    private String tag;

    public SyntacticChunkImpl(String tag, int start, int end, Sentence theSentence) {
        this.span = new Span(start, end);
        this.theSentence = theSentence;
        this.tag = tag;
    }

    public String toString() {
        List<Token> tokens = this.theSentence.getTokens();
        StringBuilder sentence = new StringBuilder();
        sentence.append("SyntacticChunk: ").append(this.tag).append(" [ ");
        for (int i = this.span.getStart(); i < this.span.getEnd(); ++i) {
            sentence.append(tokens.get(i).getLexeme()).append(" ");
        }
        sentence.append("]\n");
        return sentence.toString();
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public int getStart() {
        return this.span.getStart();
    }

    @Override
    public int getEnd() {
        return this.span.getEnd();
    }

    @Override
    public List<Token> getTokens() {
        return Collections.unmodifiableList(this.theSentence.getTokens().subList(this.getStart(), this.getEnd()));
    }
}

