/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.analyzer;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.cogroo.analyzer.Analyzer;
import org.cogroo.exceptions.CogrooRuntimeException;
import org.cogroo.text.Document;

public class Pipe
implements Analyzer {
    protected static final Logger LOGGER = Logger.getLogger(Pipe.class);
    private List<Analyzer> mChildAnalyzers = new ArrayList<Analyzer>();

    public void add(Analyzer aAnalyzer) {
        this.mChildAnalyzers.add(aAnalyzer);
    }

    @Override
    public void analyze(Document document) {
        for (Analyzer analyzer : this.mChildAnalyzers) {
            try {
                analyzer.analyze(document);
            }
            catch (Exception e) {
                LOGGER.error((Object)("An analyzer raised an exeception. Analyzer: " + analyzer.getClass().getCanonicalName() + " Document text: [" + document.getText() + "]"), (Throwable)e);
                throw new CogrooRuntimeException((Throwable)e);
            }
        }
    }
}

