/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.config;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.cogroo.analyzer.InitializationException;
import org.cogroo.config.LanguageConfiguration;
import org.cogroo.config.ObjectFactory;
import org.cogroo.util.Closeables;

public class LanguageConfigurationUtil {
    public static LanguageConfiguration get(Locale locale) {
        String file = LanguageConfigurationUtil.generateName(locale);
        InputStream in = LanguageConfigurationUtil.class.getClassLoader().getResourceAsStream(file);
        if (in != null) {
            LanguageConfiguration lc = LanguageConfigurationUtil.get(in);
            Closeables.closeQuietly((Closeable)in);
            return lc;
        }
        throw new InitializationException("Couldn't locate configuration for locale: " + locale + " The expected file was: " + file);
    }

    public static LanguageConfiguration get(InputStream configuration) {
        try {
            return LanguageConfigurationUtil.unmarshal(configuration);
        }
        catch (JAXBException e) {
            throw new InitializationException("Invalid configuration file.", e);
        }
    }

    private static String generateName(Locale locale) {
        StringBuilder str = new StringBuilder();
        str.append("models_").append(locale.getLanguage());
        if (locale.getCountry() != null && !locale.getCountry().isEmpty()) {
            str.append("_").append(locale.getCountry());
        }
        str.append(".xml");
        return str.toString();
    }

    private static LanguageConfiguration unmarshal(InputStream inputStream) throws JAXBException {
        String packageName = LanguageConfiguration.class.getPackage().getName();
        ClassLoader cl = ObjectFactory.class.getClassLoader();
        JAXBContext jc = JAXBContext.newInstance((String)packageName, (ClassLoader)cl);
        Unmarshaller u = jc.createUnmarshaller();
        return (LanguageConfiguration)u.unmarshal(inputStream);
    }

    public static void main(String[] args) throws FileNotFoundException, JAXBException {
        LanguageConfiguration lc = LanguageConfigurationUtil.get(new Locale("pt_BR"));
        System.out.println(lc.getLocale());
        System.out.println((Object)lc.getModel().get(0).getType());
        System.out.println(lc.getModel().get(0).getValue());
        System.out.println((Object)lc.getModel().get(1).getType());
        System.out.println(lc.getModel().get(1).getValue());
    }
}

