/**
 * Copyright (C) 2012 cogroo <cogroo@cogroo.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cogroo.tools.checker;

import java.util.List;

import org.cogroo.tools.checker.rules.model.Example;

public interface RuleDefinition {

  /**
   * prefixed identifier
   * 
   * @return the prefixed identifier
   */
  String getId();

  /**
   * rule category
   * 
   * @return the rule category
   */
  String getCategory();

  /**
   * rule group
   * 
   * @return the rule group
   */
  String getGroup();

  /**
   * a description
   * 
   * @return a description
   */
  String getDescription();

  /**
   * short error message generated by this rule
   * 
   * @return
   */
  RuleType getRuleType();

  /**
   * long error message generated by this rule
   * 
   * @return the long error message generated by this rule
   */
  String getMessage();

  /**
   * short error message generated by this rule
   * 
   * @return short error message generated by this rule
   */
  String getShortMessage();

  /**
   * examples of this errors catch by this rule
   * 
   * @return examples of this errors catch by this rule
   */
  List<Example> getExamples();

  /**
   * True if this definition is from a XML based rule.
   * 
   * @return True if this definition is from a XML based rule.
   */
  boolean isXMLBased();

}
