/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.checker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.Set;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.util.InvalidFormatException;
import org.apache.log4j.Logger;
import org.cogroo.analyzer.Analyzer;
import org.cogroo.analyzer.ComponentFactory;
import org.cogroo.checker.CheckAnalyzer;
import org.cogroo.checker.CheckDocument;
import org.cogroo.entities.Mistake;
import org.cogroo.entities.Sentence;
import org.cogroo.interpreters.FlorestaTagInterpreter;
import org.cogroo.text.Document;
import org.cogroo.tools.checker.Checker;
import org.cogroo.tools.checker.CheckerComposite;
import org.cogroo.tools.checker.RuleDefinition;
import org.cogroo.tools.checker.SentenceAdapter;
import org.cogroo.tools.checker.TypedChecker;
import org.cogroo.tools.checker.TypedCheckerComposite;
import org.cogroo.tools.checker.checkers.GovernmentChecker;
import org.cogroo.tools.checker.checkers.ParonymChecker;
import org.cogroo.tools.checker.checkers.PunctuationChecker;
import org.cogroo.tools.checker.checkers.RepetitionChecker;
import org.cogroo.tools.checker.checkers.SpaceChecker;
import org.cogroo.tools.checker.rules.applier.RulesApplier;
import org.cogroo.tools.checker.rules.applier.RulesProvider;
import org.cogroo.tools.checker.rules.applier.RulesTreesBuilder;
import org.cogroo.tools.checker.rules.applier.RulesTreesFromScratchAccess;
import org.cogroo.tools.checker.rules.applier.RulesTreesProvider;
import org.cogroo.tools.checker.rules.applier.RulesXmlAccess;
import org.cogroo.tools.checker.rules.dictionary.FSALexicalDictionary;
import org.cogroo.tools.checker.rules.dictionary.TagDictionary;
import org.cogroo.tools.checker.rules.model.Example;
import org.cogroo.tools.checker.rules.util.MistakeComparator;
import org.cogroo.tools.checker.rules.validator.RulePostValidatorProvider;

public class GrammarChecker
implements CheckAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(GrammarChecker.class);
    private final CheckerComposite checkers;
    private final TagDictionary td;
    private boolean allowOverlap;
    private final SentenceAdapter sentenceAdapter;
    private final TypedCheckerComposite typedCheckers;
    private final Analyzer pipe;
    private final RulePostValidatorProvider validator = new RulePostValidatorProvider();
    private static final MistakeComparator MISTAKE_COMPARATOR = new MistakeComparator();

    public GrammarChecker(Analyzer pipe) throws IllegalArgumentException, IOException {
        this(pipe, false, null);
    }

    public GrammarChecker(Analyzer pipe, boolean allowOverlap, long[] activeXmlRules) throws IllegalArgumentException, IOException {
        this.pipe = pipe;
        this.td = new TagDictionary(new FSALexicalDictionary(), false, new FlorestaTagInterpreter());
        this.sentenceAdapter = new SentenceAdapter(this.td);
        ArrayList<TypedChecker> typedCheckersList = new ArrayList<TypedChecker>();
        typedCheckersList.add(this.createRulesApplierChecker(activeXmlRules));
        typedCheckersList.add(new SpaceChecker(this.loadAbbDict()));
        typedCheckersList.add(new PunctuationChecker());
        typedCheckersList.add(new RepetitionChecker());
        this.typedCheckers = new TypedCheckerComposite((List<TypedChecker>)typedCheckersList, false);
        ArrayList<Checker> checkerList = new ArrayList<Checker>();
        checkerList.add(new GovernmentChecker());
        checkerList.add(new ParonymChecker(this.pipe));
        this.checkers = new CheckerComposite((List<Checker>)checkerList, false);
        this.allowOverlap = allowOverlap;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Created following rules:");
            int count = 0;
            for (RuleDefinition def : this.typedCheckers.getRulesDefinition()) {
                LOGGER.debug((Object)(count++ + ": " + def.getId()));
            }
            for (RuleDefinition def : this.checkers.getRulesDefinition()) {
                LOGGER.debug((Object)(count++ + ": " + def.getId()));
            }
        }
    }

    public GrammarChecker(Analyzer pipe, String serializedRule) throws IllegalArgumentException, IOException {
        this.pipe = pipe;
        this.td = new TagDictionary(new FSALexicalDictionary(), false, new FlorestaTagInterpreter());
        this.sentenceAdapter = new SentenceAdapter(this.td);
        ArrayList<TypedChecker> typedCheckersList = new ArrayList<TypedChecker>();
        typedCheckersList.add(this.createSingletonRuleChecker(serializedRule));
        this.typedCheckers = new TypedCheckerComposite((List<TypedChecker>)typedCheckersList, false);
        ArrayList<Checker> checkerList = new ArrayList<Checker>();
        this.checkers = new CheckerComposite((List<Checker>)checkerList, false);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Created following rules:");
            int count = 0;
            for (RuleDefinition def : this.typedCheckers.getRulesDefinition()) {
                LOGGER.debug((Object)(count++ + ": " + def.getId()));
            }
            for (RuleDefinition def : this.checkers.getRulesDefinition()) {
                LOGGER.debug((Object)(count++ + ": " + def.getId()));
            }
        }
    }

    public Set<RuleDefinition> getRuleDefinitions() {
        HashSet<RuleDefinition> ruleDefinitions = new HashSet<RuleDefinition>();
        ruleDefinitions.addAll(this.typedCheckers.getRulesDefinition());
        ruleDefinitions.addAll(this.checkers.getRulesDefinition());
        return ruleDefinitions;
    }

    private Dictionary loadAbbDict() throws InvalidFormatException, IOException {
        Dictionary abbDict = new Dictionary(this.getClass().getResourceAsStream("/dictionaries/pt_br/abbr.xml"));
        return abbDict;
    }

    private TypedChecker createRulesApplierChecker(long[] activeRules) {
        RulesProvider xmlProvider = new RulesProvider(RulesXmlAccess.getInstance(), false);
        RulesTreesBuilder rtb = new RulesTreesBuilder(xmlProvider, activeRules);
        RulesTreesFromScratchAccess rta = new RulesTreesFromScratchAccess(rtb);
        RulesTreesProvider rtp = new RulesTreesProvider(rta, false);
        return new RulesApplier(rtp, this.td);
    }

    private TypedChecker createSingletonRuleChecker(String serializedRule) {
        RulesProvider xmlProvider = new RulesProvider(RulesXmlAccess.getInstance(serializedRule), true);
        RulesTreesBuilder rtb = new RulesTreesBuilder(xmlProvider, null);
        RulesTreesFromScratchAccess rta = new RulesTreesFromScratchAccess(rtb);
        RulesTreesProvider rtp = new RulesTreesProvider(rta, false);
        return new RulesApplier(rtp, this.td);
    }

    public void analyze(CheckDocument document, boolean filterInvalidSuggestions) {
        this.pipe.analyze((Document)document);
        List<Mistake> mistakes = new ArrayList<Mistake>();
        List sentences = document.getSentences();
        ArrayList<Sentence> typedSentences = new ArrayList<Sentence>(sentences.size());
        for (org.cogroo.text.Sentence sentence : sentences) {
            mistakes.addAll(this.checkers.check(sentence));
            Sentence typedSentence = this.sentenceAdapter.asTypedSentence(sentence, document.getText());
            typedSentences.add(typedSentence);
            mistakes.addAll(this.typedCheckers.check(typedSentence));
        }
        document.setSentencesLegacy(typedSentences);
        Collections.sort(mistakes, MISTAKE_COMPARATOR);
        mistakes = this.filterInvalid(document, mistakes);
        if (!this.allowOverlap) {
            mistakes = this.filterOverlap((Document)document, mistakes);
        }
        if (filterInvalidSuggestions) {
            this.filterWrongSuggestions((Document)document, mistakes);
        }
        document.setMistakes(mistakes);
    }

    @Override
    public void analyze(CheckDocument document) {
        this.analyze(document, true);
    }

    private List<Mistake> filterInvalid(CheckDocument document, List<Mistake> mistakes) {
        ArrayList<Mistake> filtered = new ArrayList<Mistake>();
        for (Mistake mistake : mistakes) {
            if (!this.validator.isValid(mistake, (Document)document)) continue;
            filtered.add(mistake);
        }
        return filtered;
    }

    private List<Mistake> filterOverlap(Document doc, List<Mistake> mistakes) {
        boolean[] occupied = new boolean[doc.getText().length()];
        ArrayList<Mistake> mistakesNoOverlap = new ArrayList<Mistake>();
        boolean overlap = false;
        for (Mistake mistake : mistakes) {
            int i;
            overlap = false;
            for (i = mistake.getStart(); i < mistake.getEnd(); ++i) {
                if (!occupied[i]) continue;
                overlap = true;
            }
            if (overlap) continue;
            for (i = mistake.getStart(); i < mistake.getEnd(); ++i) {
                occupied[i] = true;
            }
            mistakesNoOverlap.add(mistake);
        }
        return mistakesNoOverlap;
    }

    private void filterWrongSuggestions(Document document, List<Mistake> mistakes) {
        String documentText = document.getText();
        for (Mistake mistake : mistakes) {
            ArrayList<String> rightSuggestions = new ArrayList<String>();
            for (String suggestion : mistake.getSuggestions()) {
                String alternativeText = documentText.substring(0, mistake.getStart()) + suggestion + documentText.substring(mistake.getEnd());
                CheckDocument alternative = new CheckDocument(alternativeText);
                this.analyze(alternative, false);
                if (alternative.getMistakes().size() == 0) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("\n****** Filtering suggestions **********: " + alternativeText + "   (OK!)\n"));
                    }
                    rightSuggestions.add(suggestion);
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("\n****** Filtering suggestions **********: " + alternativeText + "   (WRONG!)\n"));
                }
                if (rightSuggestions.size() <= 0) continue;
                mistake.setSuggestions(rightSuggestions.toArray(new String[rightSuggestions.size()]));
            }
        }
    }

    public void ignoreRule(String ruleIdentifier) {
        this.checkers.ignore(ruleIdentifier);
    }

    public void resetIgnoredRules() {
        this.checkers.resetIgnored();
    }

    private static void printExamples(List<RuleDefinition> rulesDefinition) {
        for (RuleDefinition def : rulesDefinition) {
            for (Example ex : def.getExamples()) {
                System.out.println(ex.getIncorrect());
            }
        }
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException {
        long start = System.nanoTime();
        if (args.length != 1) {
            System.err.println("Language is missing! usage: CLI pt_br");
            return;
        }
        ComponentFactory factory = ComponentFactory.create((Locale)new Locale("pt", "BR"));
        long[] rules = new long[]{129L};
        GrammarChecker cogroo = new GrammarChecker(factory.createPipe());
        System.out.println("Loading time [" + (System.nanoTime() - start) / 1000000L + "ms]");
        Scanner kb = new Scanner(System.in);
        System.out.print("Enter the sentence, q to quit, 0 for the default, or 1 to print the examples: ");
        String input = kb.nextLine();
        while (!input.equals("q")) {
            if (input.equals("0")) {
                input = "Foi ferido por uma balas perdidas.";
            } else if (input.equals("1")) {
                GrammarChecker.printExamples(new ArrayList<RuleDefinition>(cogroo.getRuleDefinitions()));
            }
            CheckDocument document = new CheckDocument();
            document.setText(input);
            cogroo.analyze(document);
            System.out.println((Object)document);
            System.out.print("Enter the sentence: ");
            input = kb.nextLine();
        }
    }
}

