/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.entities;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.cogroo.entities.Token;
import org.cogroo.entities.TokenGroup;
import org.cogroo.entities.impl.MorphologicalTag;
import org.cogroo.entities.impl.SyntacticTag;
import org.cogroo.util.ToStringHelper;

public abstract class Chunk
implements Serializable,
TokenGroup {
    private static final long serialVersionUID = -3742023174482515909L;
    protected List<Token> tokens;
    protected int firstToken;
    protected MorphologicalTag morphologicalTag;
    private String type;
    private int headIndex = -1;

    public abstract String toPlainText();

    @Override
    public List<Token> getTokens() {
        return this.tokens;
    }

    public int getFirstToken() {
        return this.firstToken;
    }

    public void setFirstToken(int firstToken) {
        this.firstToken = firstToken;
    }

    public MorphologicalTag getMorphologicalTag() {
        return this.morphologicalTag;
    }

    public void setMorphologicalTag(MorphologicalTag morphologicalTag) {
        this.morphologicalTag = morphologicalTag;
    }

    public SyntacticTag getSyntacticTag() {
        return this.tokens.get(0).getSyntacticTag();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Chunk) {
            Chunk that = (Chunk)obj;
            return Objects.equals(this.tokens, that.tokens) && Objects.equals(this.firstToken, that.firstToken) && Objects.equals(this.morphologicalTag, that.morphologicalTag);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.tokens, this.firstToken, this.morphologicalTag);
    }

    public String toString() {
        return ToStringHelper.toStringHelper((Object)this).add("text", (Object)this.toPlainText()).add("main", (Object)this.getMainToken().getLexeme()).add("mtag", (Object)this.morphologicalTag).add("tag", (Object)this.getTokens().get(0).getChunkTag()).toString();
    }

    public int getRelativeHeadIndex() {
        if (this.headIndex == -1) {
            this.headIndex = 0;
            for (int i = 0; i < this.tokens.size(); ++i) {
                if (!this.tokens.get(i).getChunkTag().toString().contains("MAIN")) continue;
                this.headIndex = i;
                break;
            }
        }
        return this.headIndex;
    }

    public Token getMainToken() {
        return this.getTokens().get(this.getRelativeHeadIndex());
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

