/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cogroo.entities.Chunk;
import org.cogroo.entities.Token;
import org.cogroo.entities.impl.MorphologicalTag;
import org.cogroo.entities.impl.SyntacticTag;
import org.cogroo.tools.checker.rules.model.TagMask;
import org.cogroo.util.ToStringHelper;

public class SyntacticChunk
implements Serializable {
    private static final long serialVersionUID = 4768788694700581906L;
    protected List<Chunk> chunks;
    protected SyntacticTag syntacticTag;
    private static final SyntacticTag SUBJ = new SyntacticTag();
    private static final SyntacticTag MV;
    private static final SyntacticTag NONE;
    private static final SyntacticTag SUBJECT_PREDICATIVE;
    private MorphologicalTag tag = null;
    private List<Token> tokens = null;

    public SyntacticChunk(List<Chunk> childChunks) {
        this.chunks = childChunks;
    }

    public String toPlainText() {
        StringBuilder chunkAsString = new StringBuilder();
        for (int i = 0; i < this.chunks.size(); ++i) {
            chunkAsString.append(this.chunks.get(i).toPlainText());
            if (i + 1 == this.chunks.size()) continue;
            chunkAsString.append(' ');
        }
        return chunkAsString.toString();
    }

    public MorphologicalTag getMorphologicalTag() {
        if (this.tag == null) {
            if (this.syntacticTag.match(NONE)) {
                this.tag = this.getChildChunks().get((int)0).getMainToken().morphologicalTag;
            } else if (this.syntacticTag.match(MV)) {
                for (Chunk verbChunk : this.getChildChunks()) {
                    if (verbChunk.getMainToken() == null) continue;
                    this.tag = verbChunk.getMainToken().getMorphologicalTag();
                    break;
                }
            } else if (this.syntacticTag.match(SUBJ) || this.syntacticTag.match(SUBJECT_PREDICATIVE)) {
                boolean hasMale = false;
                boolean hasFemale = false;
                boolean hasSingular = false;
                boolean hasPlural = false;
                TagMask.Gender lastGender = null;
                boolean multipleNP = false;
                boolean canHandle = false;
                List<Chunk> childChunks = this.filterPP(this.getChildChunks());
                if (!(childChunks == null || this.containsLemma(childChunks, "cujo", "que", "como") || this.containsClass(childChunks, TagMask.Class.NUMERAL) || this.endsWithPunct(childChunks))) {
                    if (childChunks.size() == 1 && "NP".equals(childChunks.get(0).getType())) {
                        canHandle = true;
                    } else if (childChunks.size() > 1) {
                        boolean gotE = false;
                        for (int i = 0; i < childChunks.size(); i += 2) {
                            if (i == childChunks.size() - 1 && this.checkType(childChunks.get(i), "NP")) {
                                if (!gotE) continue;
                                canHandle = true;
                                multipleNP = true;
                                continue;
                            }
                            if (!this.checkType(childChunks.get(i), "NP") || !this.checkType(childChunks.get(i + 1), null) || !this.checkLexeme(childChunks.get(i + 1), ",", "e")) break;
                            if (!this.checkLexeme(childChunks.get(i + 1), "e")) continue;
                            gotE = true;
                        }
                    }
                }
                if (canHandle) {
                    for (Chunk subjChunk : childChunks) {
                        if (this.tag == null && subjChunk.getMainToken() != null) {
                            this.tag = subjChunk.getMainToken().getMorphologicalTag();
                        }
                        if (subjChunk.getMainToken() == null) continue;
                        MorphologicalTag mt = subjChunk.getMainToken().getMorphologicalTag();
                        if (!(hasFemale && hasMale || mt.getGenderE() == null || !mt.getGenderE().equals((Object)TagMask.Gender.NEUTRAL))) {
                            hasFemale = true;
                            hasMale = true;
                            lastGender = TagMask.Gender.NEUTRAL;
                        } else if (!hasFemale && mt.getGenderE() != null && mt.getGenderE().equals((Object)TagMask.Gender.FEMALE)) {
                            hasFemale = true;
                            lastGender = TagMask.Gender.FEMALE;
                        } else if (!hasMale && mt.getGenderE() != null && mt.getGenderE().equals((Object)TagMask.Gender.MALE)) {
                            hasMale = true;
                            lastGender = TagMask.Gender.MALE;
                        }
                        if (!(hasSingular && hasPlural || mt.getNumberE() == null || !mt.getNumberE().equals((Object)TagMask.Number.NEUTRAL))) {
                            hasSingular = true;
                            hasPlural = true;
                            continue;
                        }
                        if (!hasSingular && mt.getNumberE() != null && mt.getNumberE().equals((Object)TagMask.Number.SINGULAR)) {
                            hasSingular = true;
                            continue;
                        }
                        if (hasPlural || mt.getNumberE() == null || !mt.getNumberE().equals((Object)TagMask.Number.PLURAL)) continue;
                        hasPlural = true;
                    }
                } else {
                    this.tag = this.createNeutralNoun();
                }
                this.tag = this.tag.clone();
                if (hasFemale && hasMale) {
                    if (Objects.equals(lastGender, (Object)TagMask.Gender.MALE)) {
                        this.tag.setGender(TagMask.Gender.MALE);
                    } else {
                        this.tag.setGender(TagMask.Gender.NEUTRAL);
                    }
                } else if (hasFemale) {
                    this.tag.setGender(TagMask.Gender.FEMALE);
                } else if (hasMale) {
                    this.tag.setGender(TagMask.Gender.MALE);
                }
                if (this.syntacticTag.match(SUBJ) && multipleNP) {
                    this.tag.setNumber(TagMask.Number.PLURAL);
                } else if (this.syntacticTag.match(SUBJECT_PREDICATIVE) && childChunks.size() > 1) {
                    this.tag.setNumber(TagMask.Number.NEUTRAL);
                } else if (hasSingular && hasPlural) {
                    this.tag.setNumber(TagMask.Number.NEUTRAL);
                } else if (hasSingular) {
                    this.tag.setNumber(TagMask.Number.SINGULAR);
                } else if (hasPlural) {
                    this.tag.setNumber(TagMask.Number.PLURAL);
                }
            } else {
                this.tag = this.getChildChunks().size() == 1 ? this.getChildChunks().get(0).getMainToken().getMorphologicalTag() : this.createNeutralNoun();
            }
        }
        if (this.tag.getNumberE() == null) {
            this.tag.setNumber(TagMask.Number.NEUTRAL);
        }
        if (this.tag.getGenderE() == null) {
            this.tag.setGender(TagMask.Gender.NEUTRAL);
        }
        return this.tag;
    }

    private boolean endsWithPunct(List<Chunk> childChunks) {
        Chunk lastChunk;
        List<Token> tokens;
        if (childChunks.size() > 0 && (tokens = (lastChunk = childChunks.get(childChunks.size() - 1)).getTokens()).size() > 0) {
            return TagMask.Class.PUNCTUATION_MARK.equals((Object)tokens.get(tokens.size() - 1).getMorphologicalTag().getClazzE());
        }
        return false;
    }

    private List<Chunk> filterPP(List<Chunk> childChunks) {
        ArrayList<Chunk> out = new ArrayList<Chunk>();
        if (childChunks.size() == 1) {
            return childChunks;
        }
        for (int i = 0; i < childChunks.size(); ++i) {
            Chunk c = childChunks.get(i);
            if (i < childChunks.size() - 1 && Objects.equals(c.getType(), "PP") && Objects.equals(childChunks.get(i + 1).getType(), "NP")) {
                ++i;
                continue;
            }
            out.add(c);
        }
        return out;
    }

    private boolean containsClass(List<Chunk> childChunks, TagMask.Class ... classes) {
        boolean match = false;
        for (Chunk chunk : childChunks) {
            block1: for (Token t : chunk.getTokens()) {
                for (TagMask.Class c : classes) {
                    if (t.getMorphologicalTag() == null || !c.equals((Object)t.getMorphologicalTag().getClazzE())) continue;
                    match = true;
                    continue block1;
                }
            }
        }
        return match;
    }

    private boolean containsLemma(List<Chunk> childChunks, String ... arr) {
        boolean match = false;
        for (Chunk chunk : childChunks) {
            for (Token t : chunk.getTokens()) {
                block2: for (String lexeme : arr) {
                    for (String p : t.getPrimitive()) {
                        if (!lexeme.equalsIgnoreCase(p)) continue;
                        match = true;
                        continue block2;
                    }
                }
            }
        }
        return match;
    }

    private MorphologicalTag createNeutralNoun() {
        MorphologicalTag t = new MorphologicalTag();
        t.setClazz(TagMask.Class.NOUN);
        t.setGender(TagMask.Gender.NEUTRAL);
        t.setNumber(TagMask.Number.NEUTRAL);
        return t;
    }

    private boolean checkLexeme(Chunk chunk, String ... arr) {
        boolean match = false;
        if (chunk.getTokens().size() == 1) {
            for (String lexeme : arr) {
                if (!Objects.equals(chunk.getTokens().get(0).getLexeme(), lexeme)) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    private boolean checkType(Chunk chunk, String string) {
        return Objects.equals(chunk.getType(), string);
    }

    public MorphologicalTag getMorphologicalTag2xx() {
        if (this.tag == null) {
            if (this.syntacticTag.match(NONE)) {
                this.tag = this.getChildChunks().get((int)0).getMainToken().morphologicalTag;
            } else if (this.syntacticTag.match(MV)) {
                for (Chunk verbChunk : this.getChildChunks()) {
                    if (verbChunk.getMainToken() == null) continue;
                    this.tag = verbChunk.getMainToken().getMorphologicalTag();
                    break;
                }
            } else if (this.syntacticTag.match(SUBJ)) {
                Chunk cc;
                TagMask.Gender gender = null;
                TagMask.Number number = null;
                List<Chunk> childChunks = this.filterNP(this.getChildChunks());
                MorphologicalTag mtag = childChunks.get(0).getMorphologicalTag().clone();
                gender = mtag.getGenderE();
                number = mtag.getNumberE();
                for (int i = 1; i < childChunks.size() && !(cc = childChunks.get(i)).getMorphologicalTag().getClazzE().equals((Object)TagMask.Class.PREPOSITION); ++i) {
                    number = TagMask.Number.PLURAL;
                    TagMask.Gender otherGender = cc.getMorphologicalTag().getGenderE();
                    gender = this.getStronger(gender, otherGender);
                }
                mtag.setGender(gender);
                mtag.setNumber(number);
                this.tag = mtag;
            }
        }
        return this.tag;
    }

    private List<Chunk> filterNP(List<Chunk> childChunks) {
        ArrayList<Chunk> filtered = new ArrayList<Chunk>();
        for (Chunk c : childChunks) {
            if (c.getMorphologicalTag().getClazzE().equals((Object)TagMask.Class.PREPOSITION)) break;
            if (!Objects.equals(c.getType(), "NP")) continue;
            filtered.add(c);
        }
        if (filtered.size() > 0) {
            return filtered;
        }
        return childChunks;
    }

    private TagMask.Number getStronger(TagMask.Number a, TagMask.Number b) {
        if (TagMask.Number.PLURAL.equals((Object)a) || TagMask.Number.PLURAL.equals((Object)b)) {
            return TagMask.Number.PLURAL;
        }
        if (TagMask.Number.NEUTRAL.equals((Object)a)) {
            return b;
        }
        if (TagMask.Number.NEUTRAL.equals((Object)b)) {
            return a;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a;
    }

    private TagMask.Gender getStronger(TagMask.Gender a, TagMask.Gender b) {
        if (TagMask.Gender.MALE.equals((Object)a) || TagMask.Gender.MALE.equals((Object)b)) {
            return TagMask.Gender.MALE;
        }
        if (TagMask.Gender.NEUTRAL.equals((Object)a)) {
            return b;
        }
        if (TagMask.Gender.NEUTRAL.equals((Object)b)) {
            return a;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a;
    }

    public SyntacticTag getSyntacticTag() {
        return this.syntacticTag;
    }

    public void setSyntacticTag(SyntacticTag syntacticTag) {
        this.syntacticTag = syntacticTag;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SyntacticChunk) {
            SyntacticChunk that = (SyntacticChunk)obj;
            return Objects.equals(this.getChildChunks(), that.getChildChunks()) && Objects.equals(this.syntacticTag, that.syntacticTag);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getChildChunks(), this.syntacticTag);
    }

    public List<Chunk> getChildChunks() {
        return this.chunks;
    }

    public String toString() {
        return ToStringHelper.toStringHelper((Object)this).add("tag", (Object)this.syntacticTag).add("mtag", (Object)this.getMorphologicalTag()).add("toks", (Object)this.toPlainText()).toString();
    }

    public int getFirstToken() {
        return this.chunks.get(0).getFirstToken();
    }

    public List<Token> getTokens() {
        if (this.tokens == null) {
            ArrayList<Token> tks = new ArrayList<Token>();
            for (Chunk c : this.chunks) {
                tks.addAll(c.getTokens());
            }
            this.tokens = Collections.unmodifiableList(tks);
        }
        return this.tokens;
    }

    static {
        SUBJ.setSyntacticFunction(TagMask.SyntacticFunction.SUBJECT);
        MV = new SyntacticTag();
        MV.setSyntacticFunction(TagMask.SyntacticFunction.VERB);
        NONE = new SyntacticTag();
        NONE.setSyntacticFunction(TagMask.SyntacticFunction.NONE);
        SUBJECT_PREDICATIVE = new SyntacticTag();
        SUBJECT_PREDICATIVE.setSyntacticFunction(TagMask.SyntacticFunction.SUBJECT_PREDICATIVE);
    }
}

