/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.entities.tree;

import java.util.ArrayList;
import java.util.List;
import org.cogroo.entities.Sentence;
import org.cogroo.entities.Token;
import org.cogroo.entities.impl.ChunkTag;
import org.cogroo.entities.impl.SyntacticTag;
import org.cogroo.entities.tree.Leaf;
import org.cogroo.entities.tree.Node;
import org.cogroo.tools.checker.rules.model.TagMask;

public class OldStyleModel {
    private static final ChunkTag BOUNDARY_NOUN_PHRASE = new ChunkTag();
    private static final ChunkTag BOUNDARY_NOUN_PHRASE_MAIN;
    private static final ChunkTag BOUNDARY_VERB_PHRASE_MAIN;
    private static final ChunkTag INTERMEDIARY_NOUN_PHRASE;
    private static final ChunkTag INTERMEDIARY_NOUN_PHRASE_MAIN;
    private static final ChunkTag INTERMEDIARY_VERB_PHRASE;
    private static final ChunkTag OTHER;
    private static final SyntacticTag SYNT_NONE;
    private static final SyntacticTag SYNT_SUBJECT;
    private static final SyntacticTag SYNT_VERB;

    public static Node createTree(Sentence sent) {
        List<Token> tokens = sent.getTokens();
        ArrayList<List<Token>> tokenClusters = new ArrayList<List<Token>>();
        for (Token token : tokens) {
            if (OldStyleModel.isOtherPhrase(token) || OldStyleModel.isBoundary(token)) {
                OldStyleModel.addNewCluster(tokenClusters, token);
                continue;
            }
            if (!OldStyleModel.isContinuation(tokenClusters, token)) continue;
            OldStyleModel.merge(tokenClusters, token);
        }
        Node root = new Node();
        root.setLevel(0);
        root.setSyntacticTag("S");
        for (List list : tokenClusters) {
            String syntTag = OldStyleModel.syntactTagForCluster(list);
            if (syntTag != null) {
                OldStyleModel.addSyntNode(list, syntTag, root);
                continue;
            }
            OldStyleModel.addPhraseNode(list, root);
        }
        return root;
    }

    private static void addPhraseNode(List<Token> cluster, Node parent) {
        String tag = OldStyleModel.phraseTagForCluster(cluster);
        if (tag != null) {
            OldStyleModel.addPhraseNode(cluster, tag, parent);
        } else {
            OldStyleModel.addLeafs(cluster, parent);
        }
    }

    private static void addLeafs(List<Token> cluster, Node parent) {
        for (Token token : cluster) {
            Leaf n = new Leaf();
            n.setLevel(parent.getLevel() + 1);
            n.setMorphologicalTag(token.getMorphologicalTag().getClazzE().toString());
            n.setLexeme(token.getLexeme());
            n.setLemma(token.getPrimitive());
            parent.addElement(n);
        }
    }

    private static void addPhraseNode(List<Token> cluster, String tag, Node parent) {
        Node n = new Node();
        n.setLevel(parent.getLevel() + 1);
        n.setSyntacticTag(tag);
        parent.addElement(n);
        OldStyleModel.addLeafs(cluster, n);
    }

    private static String phraseTagForCluster(List<Token> cluster) {
        for (Token token : cluster) {
            if (OldStyleModel.isBoundaryOfNounPhrase(token) || OldStyleModel.isIntermediaryNounPhrase(token)) {
                return "NP";
            }
            if (!OldStyleModel.isBoundaryOfVerbPhrase(token) && !OldStyleModel.isIntermediaryVerbPhrase(token)) continue;
            return "VP";
        }
        return null;
    }

    private static void addSyntNode(List<Token> cluster, String syntTag, Node parent) {
        Node n = new Node();
        n.setLevel(parent.getLevel() + 1);
        n.setSyntacticTag(syntTag);
        parent.addElement(n);
        OldStyleModel.addPhraseNode(cluster, n);
    }

    private static String syntactTagForCluster(List<Token> cluster) {
        for (Token token : cluster) {
            if (token.getSyntacticTag().match(SYNT_SUBJECT)) {
                return "SUBJ";
            }
            if (!token.getSyntacticTag().match(SYNT_VERB)) continue;
            return "VERB";
        }
        return null;
    }

    private static void merge(List<List<Token>> tokenClusters, Token token) {
        tokenClusters.get(tokenClusters.size() - 1).add(token);
    }

    private static Token getLastTokenOfCluster(List<List<Token>> tokenClusters) {
        if (tokenClusters.size() > 0) {
            List<Token> tokenCluster = tokenClusters.get(tokenClusters.size() - 1);
            return tokenCluster.get(tokenCluster.size() - 1);
        }
        return null;
    }

    private static boolean isContinuation(List<List<Token>> tokenClusters, Token token) {
        Token lastToken = OldStyleModel.getLastTokenOfCluster(tokenClusters);
        if (lastToken == null) {
            return false;
        }
        if (OldStyleModel.isBoundaryOfNounPhrase(lastToken) || OldStyleModel.isIntermediaryNounPhrase(lastToken)) {
            return OldStyleModel.isIntermediaryNounPhrase(token);
        }
        if (OldStyleModel.isBoundaryOfVerbPhrase(lastToken) || OldStyleModel.isIntermediaryVerbPhrase(lastToken)) {
            return OldStyleModel.isIntermediaryVerbPhrase(token);
        }
        return false;
    }

    private static void addNewCluster(List<List<Token>> tokenClusters, Token token) {
        ArrayList<Token> other = new ArrayList<Token>();
        other.add(token);
        tokenClusters.add(other);
    }

    private static boolean isBoundary(Token token) {
        return token.getChunkTag().match(BOUNDARY_NOUN_PHRASE) || token.getChunkTag().match(BOUNDARY_NOUN_PHRASE_MAIN) || token.getChunkTag().match(BOUNDARY_VERB_PHRASE_MAIN);
    }

    private static boolean isBoundaryOfNounPhrase(Token token) {
        return token.getChunkTag().match(BOUNDARY_NOUN_PHRASE) || token.getChunkTag().match(BOUNDARY_NOUN_PHRASE_MAIN);
    }

    private static boolean isBoundaryOfVerbPhrase(Token token) {
        return token.getChunkTag().match(BOUNDARY_VERB_PHRASE_MAIN);
    }

    private static boolean isIntermediaryNounPhrase(Token token) {
        return token.getChunkTag().match(INTERMEDIARY_NOUN_PHRASE) || token.getChunkTag().match(INTERMEDIARY_NOUN_PHRASE_MAIN);
    }

    private static boolean isIntermediaryVerbPhrase(Token token) {
        return token.getChunkTag().match(INTERMEDIARY_VERB_PHRASE);
    }

    private static boolean isOtherPhrase(Token token) {
        return token.getChunkTag().match(OTHER);
    }

    static {
        BOUNDARY_NOUN_PHRASE.setChunkFunction(TagMask.ChunkFunction.BOUNDARY_NOUN_PHRASE);
        BOUNDARY_NOUN_PHRASE_MAIN = new ChunkTag();
        BOUNDARY_NOUN_PHRASE_MAIN.setChunkFunction(TagMask.ChunkFunction.BOUNDARY_NOUN_PHRASE_MAIN);
        BOUNDARY_VERB_PHRASE_MAIN = new ChunkTag();
        BOUNDARY_VERB_PHRASE_MAIN.setChunkFunction(TagMask.ChunkFunction.BOUNDARY_VERB_PHRASE_MAIN);
        INTERMEDIARY_NOUN_PHRASE = new ChunkTag();
        INTERMEDIARY_NOUN_PHRASE.setChunkFunction(TagMask.ChunkFunction.INTERMEDIARY_NOUN_PHRASE);
        INTERMEDIARY_NOUN_PHRASE_MAIN = new ChunkTag();
        INTERMEDIARY_NOUN_PHRASE_MAIN.setChunkFunction(TagMask.ChunkFunction.INTERMEDIARY_NOUN_PHRASE_MAIN);
        INTERMEDIARY_VERB_PHRASE = new ChunkTag();
        INTERMEDIARY_VERB_PHRASE.setChunkFunction(TagMask.ChunkFunction.INTERMEDIARY_VERB_PHRASE);
        OTHER = new ChunkTag();
        OTHER.setChunkFunction(TagMask.ChunkFunction.OTHER);
        SYNT_NONE = new SyntacticTag();
        SYNT_NONE.setSyntacticFunction(TagMask.SyntacticFunction.NONE);
        SYNT_SUBJECT = new SyntacticTag();
        SYNT_SUBJECT.setSyntacticFunction(TagMask.SyntacticFunction.SUBJECT);
        SYNT_VERB = new SyntacticTag();
        SYNT_VERB.setSyntacticFunction(TagMask.SyntacticFunction.VERB);
    }
}

