/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.errorreport;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import org.apache.log4j.Logger;
import org.cogroo.tools.checker.rules.exception.RulesException;
import org.cogroo.tools.errorreport.model.ErrorReport;
import org.xml.sax.InputSource;

public class ErrorReportAccess {
    private static final Logger LOGGER = Logger.getLogger(ErrorReportAccess.class);
    private static final String ENCODING = "UTF-8";

    public ErrorReport getErrorReport(Reader xml) {
        ErrorReport errorReport = null;
        try {
            InputSource inputSource = new InputSource(xml);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ErrorReport.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent ve) {
                    if (ve.getSeverity() != 0) {
                        ValidationEventLocator vel = ve.getLocator();
                        LOGGER.warn((Object)("Line:Col[" + vel.getLineNumber() + ":" + vel.getColumnNumber() + "]:" + ve.getMessage()));
                    }
                    return true;
                }
            });
            errorReport = (ErrorReport)unmarshaller.unmarshal(inputSource);
        }
        catch (JAXBException e) {
            LOGGER.error((Object)"Error parsing file", (Throwable)e);
            throw new RulesException("Failed reading file");
        }
        return errorReport;
    }

    public static String serialize(ErrorReport newRules) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Persisting ErrorReport in a XML...");
        }
        String ret = null;
        try {
            StringWriter sw = new StringWriter();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ErrorReport.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)ENCODING);
            marshaller.marshal((Object)newRules, (Writer)sw);
            sw.close();
            ret = sw.toString();
        }
        catch (PropertyException e) {
            throw new RulesException("Failed to save the ErrorReport");
        }
        catch (IOException e) {
            throw new RulesException("Failed to save the ErrorReport");
        }
        catch (JAXBException e) {
            throw new RulesException("Failed to save the ErrorReport: " + e.getMessage());
        }
        return ret;
    }
}

