/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.gc.cmdline.grammarchecker;

import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import org.cogroo.analyzer.ComponentFactory;
import org.cogroo.analyzer.InitializationException;
import org.cogroo.checker.GrammarChecker;
import org.cogroo.gc.cmdline.grammarchecker.LanguageCountryParams;
import org.cogroo.tools.checker.RuleDefinition;
import org.cogroo.tools.checker.rules.model.Example;
import org.cogroo.util.StringsUtil;

public class ExamplesTool
extends BasicCmdLineTool {
    public String getShortDescription() {
        return "prints examples from the working rules";
    }

    public String getHelp() {
        return this.getBasicHelp(Params.class);
    }

    public void run(String[] args) {
        GrammarChecker cogroo;
        ComponentFactory factory;
        Params params = (Params)this.validateAndParseParams(args, Params.class);
        String lang = params.getLang();
        CmdLineUtil.checkLanguageCode((String)lang);
        String country = params.getCountry();
        if (StringsUtil.isNullOrEmpty((String)country)) {
            throw new TerminateToolException(1, "Country cannot be empty. Example country: BR");
        }
        try {
            factory = ComponentFactory.create((Locale)new Locale(lang, country));
        }
        catch (InitializationException e) {
            e.printStackTrace();
            throw new TerminateToolException(1, "Could not find configuration for " + lang + ". Only " + new Locale("pt", "BR") + " might be supported for now.");
        }
        try {
            cogroo = new GrammarChecker(factory.createPipe());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TerminateToolException(1, "Could not create pipeline!");
        }
        ExamplesTool.printExamples(cogroo.getRuleDefinitions(), params.getCorrect());
    }

    private static void printExamples(Collection<RuleDefinition> rulesDefinition, boolean correct) {
        for (RuleDefinition def : rulesDefinition) {
            for (Example ex : def.getExamples()) {
                if (correct) {
                    System.out.println(ex.getCorrect());
                    continue;
                }
                System.out.println(ex.getIncorrect());
            }
        }
    }

    static interface Params
    extends LanguageCountryParams {
        @ArgumentParser.ParameterDescription(valueName="value", description="if true prints correct examples instead of incorrect.")
        @ArgumentParser.OptionalParameter(defaultValue="false")
        public Boolean getCorrect();
    }
}

