/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.gc.cmdline.grammarchecker;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Scanner;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import org.cogroo.analyzer.ComponentFactory;
import org.cogroo.analyzer.InitializationException;
import org.cogroo.checker.CheckDocument;
import org.cogroo.checker.GrammarChecker;
import org.cogroo.gc.cmdline.grammarchecker.LanguageCountryParams;
import org.cogroo.text.Document;
import org.cogroo.util.FileUtils;
import org.cogroo.util.StringsUtil;
import org.cogroo.util.TextUtils;

public class GrammarCheckerTool
extends BasicCmdLineTool {
    public String getShortDescription() {
        return "checks a text for grammar errors";
    }

    public String getHelp() {
        return this.getBasicHelp(Params.class);
    }

    public void run(String[] args) {
        GrammarChecker cogroo;
        ComponentFactory factory;
        Params params = (Params)this.validateAndParseParams(args, Params.class);
        String lang = params.getLang();
        CmdLineUtil.checkLanguageCode((String)lang);
        String country = params.getCountry();
        if (StringsUtil.isNullOrEmpty((String)country)) {
            throw new TerminateToolException(1, "Country cannot be empty. Example country: BR");
        }
        File rulesFile = params.getRulesFile();
        if (rulesFile != null) {
            CmdLineUtil.checkInputFile((String)"Rules file", (File)rulesFile);
        }
        long start = System.nanoTime();
        try {
            factory = ComponentFactory.create((Locale)new Locale(lang, country));
        }
        catch (InitializationException e) {
            e.printStackTrace();
            throw new TerminateToolException(1, "Could not find configuration for " + lang + ". Only " + new Locale("pt", "BR") + " might be supported for now.");
        }
        try {
            if (rulesFile == null) {
                cogroo = new GrammarChecker(factory.createPipe());
            } else {
                String serializedRules = FileUtils.readFile((File)rulesFile, (Charset)StandardCharsets.UTF_8);
                cogroo = new GrammarChecker(factory.createPipe(), serializedRules);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TerminateToolException(1, "Could not create pipeline!");
        }
        System.out.println("Loading time [" + (System.nanoTime() - start) / 1000000L + "ms]");
        Scanner kb = new Scanner(System.in);
        System.out.print("Enter the sentence or 'q' to quit: ");
        String input = kb.nextLine();
        while (!input.equals("q")) {
            CheckDocument document = new CheckDocument();
            document.setText(input);
            cogroo.analyze(document);
            if (params.getShowAnalysis().booleanValue()) {
                System.out.println(TextUtils.nicePrint((Document)document));
            }
            System.out.println(document.getMistakesAsString());
            System.out.print("Enter the sentence or 'q' to quit: ");
            input = kb.nextLine();
        }
    }

    static interface Params
    extends LanguageCountryParams {
        @ArgumentParser.ParameterDescription(valueName="show", description="if true will show text analysis.")
        @ArgumentParser.OptionalParameter(defaultValue="false")
        public Boolean getShowAnalysis();

        @ArgumentParser.ParameterDescription(valueName="rulesXml", description="if set will use a custom rules file")
        @ArgumentParser.OptionalParameter
        public File getRulesFile();
    }
}

