/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.interpreters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opennlp.tools.util.Cache;
import org.apache.log4j.Logger;
import org.cogroo.entities.impl.ChunkTag;
import org.cogroo.entities.impl.MorphologicalTag;
import org.cogroo.entities.impl.SyntacticTag;
import org.cogroo.interpreters.TagInterpreter;
import org.cogroo.tools.checker.rules.model.TagMask;

public class FlorestaTagInterpreter
implements TagInterpreter {
    private static final Map<Enum<?>, String> ENUM_MTAG_PARTS;
    private static final Map<String, List<Enum<?>>> MTAG_PARTS_ENUM;
    private static final Map<TagMask.ChunkFunction, String> ENUM_CTAG_PARTS;
    private static final Map<String, List<TagMask.ChunkFunction>> CTAG_PARTS_ENUM;
    private static final Map<TagMask.SyntacticFunction, String> ENUM_STAG_PARTS;
    private static final Map<String, List<TagMask.SyntacticFunction>> STAG_PARTS_ENUM;
    protected static final Logger LOGGER;
    private static final String SEP = "=";
    private final Cache cache = new Cache(200);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MorphologicalTag parseMorphologicalTag(String tagString) {
        Cache tags;
        if (tagString == null) {
            return null;
        }
        Cache cache = this.cache;
        synchronized (cache) {
            if (this.cache.containsKey((Object)tagString)) {
                return ((MorphologicalTag)this.cache.get((Object)tagString)).clone();
            }
        }
        if (tagString.endsWith("#-")) {
            tagString = tagString.substring(0, tagString.length() - 2);
        }
        MorphologicalTag m = new MorphologicalTag();
        for (String tag : tags = tagString.split("[#=]")) {
            if (MTAG_PARTS_ENUM.containsKey(tag)) {
                List<Enum<?>> tagE = MTAG_PARTS_ENUM.get(tag);
                for (Enum<?> t : tagE) {
                    if (t instanceof TagMask.Class) {
                        m.setClazz((TagMask.Class)t);
                        continue;
                    }
                    if (t instanceof TagMask.Gender) {
                        m.setGender((TagMask.Gender)t);
                        continue;
                    }
                    if (t instanceof TagMask.Number) {
                        m.setNumber((TagMask.Number)t);
                        continue;
                    }
                    if (t instanceof TagMask.Case) {
                        m.setCase((TagMask.Case)t);
                        continue;
                    }
                    if (t instanceof TagMask.Person) {
                        m.setPerson((TagMask.Person)t);
                        continue;
                    }
                    if (t instanceof TagMask.Tense) {
                        m.setTense((TagMask.Tense)t);
                        continue;
                    }
                    if (t instanceof TagMask.Mood) {
                        m.setMood((TagMask.Mood)t);
                        continue;
                    }
                    if (!(t instanceof TagMask.Punctuation)) continue;
                    m.setPunctuation((TagMask.Punctuation)t);
                }
                continue;
            }
            if (tag.length() == 1 || "--".equals(tag) || "...".equals(tag)) {
                m.setClazz(TagMask.Class.PUNCTUATION_MARK);
                if (",".equals(tag)) {
                    m.setPunctuation(TagMask.Punctuation.NSEP);
                    continue;
                }
                if (".".equals(tag) || "!".equals(tag) || "?".equals(tag)) {
                    m.setPunctuation(TagMask.Punctuation.ABS);
                    continue;
                }
                if ("(".equals(tag) || ")".equals(tag)) {
                    m.setPunctuation(TagMask.Punctuation.BIN);
                    continue;
                }
                m.setPunctuation(TagMask.Punctuation.REL);
                continue;
            }
            if ("n:".equals(tag)) {
                m.setClazz(TagMask.Class.NOUN);
                continue;
            }
            if ("intj".equals(tag)) {
                m.setClazz(TagMask.Class.INTERJECTION);
                continue;
            }
            if ("pp".equals(tag)) {
                m.setClazz(TagMask.Class.PREPOSITION);
                continue;
            }
            if ("np".equals(tag)) {
                m.setClazz(TagMask.Class.NOUN);
                continue;
            }
            if ("vp".equals(tag)) {
                m.setClazz(TagMask.Class.INFINITIVE_VERB);
                continue;
            }
            if (tag.contains("<") || "P.vp".equals(tag) || "GER".equals(tag)) continue;
            System.out.println(tag);
        }
        if (m.toString() == null || m.toString().length() == 0) {
            LOGGER.error((Object)("Invalid MorphologicalTag: " + tagString));
        }
        Cache cache2 = this.cache;
        synchronized (cache2) {
            if (!this.cache.containsKey((Object)tagString)) {
                this.cache.put((Object)tagString, (Object)m.clone());
            }
        }
        return m;
    }

    @Override
    public ChunkTag parseChunkTag(String tagString) {
        ChunkTag ct = new ChunkTag();
        List<TagMask.ChunkFunction> tag = CTAG_PARTS_ENUM.get(tagString);
        if (tag != null && tag.size() != 0) {
            TagMask.ChunkFunction en = tag.get(0);
            ct.setChunkFunction(en);
        } else {
            ct.setChunkFunction(TagMask.ChunkFunction.OTHER);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.error((Object)("Invalid ChunkTag: " + tagString));
            }
        }
        return ct;
    }

    @Override
    public SyntacticTag parseSyntacticTag(String tagString) {
        SyntacticTag st = new SyntacticTag();
        List<TagMask.SyntacticFunction> tag = STAG_PARTS_ENUM.get(tagString);
        if (tag != null && tag.size() != 0) {
            TagMask.SyntacticFunction en = tag.get(0);
            st.setSyntacticFunction(en);
        } else {
            st.setSyntacticFunction(TagMask.SyntacticFunction.NONE);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Invalid ChunkTag: " + tagString));
            }
        }
        return st;
    }

    @Override
    public String serialize(MorphologicalTag tag) {
        StringBuilder res = new StringBuilder();
        if (tag.getClazzE() != null) {
            res.append(this.serializer(tag.getClazzE()) + SEP);
        }
        if (tag.getGenderE() != null) {
            res.append(this.serializer(tag.getGenderE()) + SEP);
        }
        if (tag.getTense() != null) {
            res.append(this.serializer(tag.getTense()) + SEP);
        }
        if (tag.getMood() != null && tag.getTense() == null) {
            res.append(this.serializer(tag.getMood()) + SEP);
        }
        if (tag.getPersonE() != null && tag.getNumberE() != null) {
            String s = this.serializer(tag.getPersonE());
            if (!s.contains("S") && !s.contains("P")) {
                res.append(s + this.serializer(tag.getNumberE()) + SEP);
            } else {
                res.append(s + SEP);
            }
        } else if (tag.getNumberE() != null) {
            res.append(this.serializer(tag.getNumberE()) + SEP);
        }
        if (tag.getCase() != null) {
            res.append(this.serializer(tag.getCase()) + SEP);
        }
        if (tag.getMood() != null && tag.getTense() != null) {
            res.append(this.serializer(tag.getMood()) + SEP);
        }
        if (tag.getPunctuation() != null) {
            res.append(this.serializer(tag.getPunctuation()) + SEP);
        }
        if (res.length() == 0) {
            LOGGER.error((Object)("Unable to serialize MorphologicalTag: " + tag));
        }
        if (res.length() > 1) {
            return res.substring(0, res.length() - 1);
        }
        return null;
    }

    @Override
    public String serialize(ChunkTag tag) {
        String value = this.serializer(tag.getChunkFunction());
        return value;
    }

    @Override
    public String serialize(SyntacticTag tag) {
        String value = this.serializer(tag.getSyntacticFunction());
        return value;
    }

    @Override
    public String serialize(TagMask.SyntacticFunction tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.ChunkFunction tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.Class tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.Gender tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.Number tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.Case tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.Person tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.Tense tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.Mood tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.Punctuation tag) {
        return this.serializer(tag);
    }

    private String serializer(Enum<?> value) {
        if (ENUM_MTAG_PARTS.containsKey(value)) {
            return ENUM_MTAG_PARTS.get(value);
        }
        return "";
    }

    private String serializer(TagMask.SyntacticFunction value) {
        if (ENUM_STAG_PARTS.containsKey((Object)value)) {
            return ENUM_STAG_PARTS.get((Object)value);
        }
        return "";
    }

    private String serializer(TagMask.ChunkFunction value) {
        if (ENUM_CTAG_PARTS.containsKey((Object)value)) {
            return ENUM_CTAG_PARTS.get((Object)value);
        }
        return "";
    }

    static {
        LOGGER = Logger.getLogger(FlorestaTagInterpreter.class);
        HashMap<TagMask.ChunkFunction, String> cenumElements = new HashMap<TagMask.ChunkFunction, String>(7);
        cenumElements.put(TagMask.ChunkFunction.OTHER, "O");
        cenumElements.put(TagMask.ChunkFunction.BOUNDARY_NOUN_PHRASE, "B-NP");
        cenumElements.put(TagMask.ChunkFunction.BOUNDARY_NOUN_PHRASE_MAIN, "B-NP*");
        cenumElements.put(TagMask.ChunkFunction.INTERMEDIARY_NOUN_PHRASE, "I-NP");
        cenumElements.put(TagMask.ChunkFunction.INTERMEDIARY_NOUN_PHRASE_MAIN, "I-NP*");
        cenumElements.put(TagMask.ChunkFunction.BOUNDARY_VERB_PHRASE_MAIN, "B-VP*");
        cenumElements.put(TagMask.ChunkFunction.INTERMEDIARY_VERB_PHRASE, "I-VP");
        ENUM_CTAG_PARTS = Collections.unmodifiableMap(cenumElements);
        Set<TagMask.ChunkFunction> k = ENUM_CTAG_PARTS.keySet();
        HashMap stringCElements = new HashMap(7);
        for (TagMask.ChunkFunction tagE : k) {
            ArrayList<TagMask.ChunkFunction> values = new ArrayList<TagMask.ChunkFunction>();
            values.add(tagE);
            stringCElements.put(ENUM_CTAG_PARTS.get((Object)tagE), Collections.unmodifiableList(values));
        }
        stringCElements.put("B-VP", Collections.singletonList(TagMask.ChunkFunction.BOUNDARY_VERB_PHRASE_MAIN));
        CTAG_PARTS_ENUM = Collections.unmodifiableMap(stringCElements);
        HashMap<TagMask.SyntacticFunction, String> senumElements = new HashMap<TagMask.SyntacticFunction, String>(3);
        senumElements.put(TagMask.SyntacticFunction.NONE, "-");
        senumElements.put(TagMask.SyntacticFunction.SUBJECT, "SUBJ");
        senumElements.put(TagMask.SyntacticFunction.VERB, "P");
        senumElements.put(TagMask.SyntacticFunction.INDIRECT_OBJECT, "PIV");
        senumElements.put(TagMask.SyntacticFunction.DIRECT_OBJECT, "ACC");
        senumElements.put(TagMask.SyntacticFunction.SUBJECT_PREDICATIVE, "SC");
        senumElements.put(TagMask.SyntacticFunction.IDENTIFYING_APPOSITION, "APP");
        senumElements.put(TagMask.SyntacticFunction.ADVERBIAL_ADJUNCT, "ADVL");
        ENUM_STAG_PARTS = Collections.unmodifiableMap(senumElements);
        Set<TagMask.SyntacticFunction> k1 = ENUM_STAG_PARTS.keySet();
        HashMap stringSElements = new HashMap(3);
        for (TagMask.SyntacticFunction tagE : k1) {
            ArrayList<TagMask.SyntacticFunction> values = new ArrayList<TagMask.SyntacticFunction>();
            values.add(tagE);
            stringSElements.put(ENUM_STAG_PARTS.get((Object)tagE), Collections.unmodifiableList(values));
        }
        ArrayList<TagMask.SyntacticFunction> _OtherVerbs = new ArrayList<TagMask.SyntacticFunction>();
        _OtherVerbs.add(TagMask.SyntacticFunction.VERB);
        stringSElements.put("AUX", Collections.unmodifiableList(_OtherVerbs));
        stringSElements.put("PAUX", Collections.unmodifiableList(_OtherVerbs));
        stringSElements.put("MV", Collections.unmodifiableList(_OtherVerbs));
        stringSElements.put("PMV", Collections.unmodifiableList(_OtherVerbs));
        STAG_PARTS_ENUM = Collections.unmodifiableMap(stringSElements);
        HashMap<Enum, String> menumElements = new HashMap<Enum, String>();
        menumElements.put(TagMask.Class.NOUN, "n");
        menumElements.put(TagMask.Class.PROPER_NOUN, "prop");
        menumElements.put(TagMask.Class.ARTICLE, "art");
        menumElements.put(TagMask.Class.PREPOSITION, "prp");
        menumElements.put(TagMask.Class.ADJECTIVE, "adj");
        menumElements.put(TagMask.Class.ADVERB, "adv");
        menumElements.put(TagMask.Class.NUMERAL, "num");
        menumElements.put(TagMask.Class.SUBORDINATING_CONJUNCTION, "conj-s");
        menumElements.put(TagMask.Class.COORDINATING_CONJUNCTION, "conj-c");
        menumElements.put(TagMask.Class.INTERJECTION, "intj");
        menumElements.put(TagMask.Class.PUNCTUATION_MARK, "pnt");
        menumElements.put(TagMask.Class.FINITIVE_VERB, "v-fin");
        menumElements.put(TagMask.Class.INFINITIVE_VERB, "v-inf");
        menumElements.put(TagMask.Class.PARTICIPLE_VERB, "v-pcp");
        menumElements.put(TagMask.Class.GERUND_VERB, "v-ger");
        menumElements.put(TagMask.Class.PREFIX, "ec");
        menumElements.put(TagMask.Class.NOUN_ADJECTIVE, "n-adj");
        menumElements.put(TagMask.Class.PRONOUN, "pron");
        menumElements.put(TagMask.Class.PERSONAL_PRONOUN, "pron-pers");
        menumElements.put(TagMask.Gender.MALE, "M");
        menumElements.put(TagMask.Gender.FEMALE, "F");
        menumElements.put(TagMask.Gender.NEUTRAL, "M/F");
        menumElements.put(TagMask.Number.SINGULAR, "S");
        menumElements.put(TagMask.Number.PLURAL, "P");
        menumElements.put(TagMask.Number.NEUTRAL, "S/P");
        menumElements.put(TagMask.Case.ACCUSATIVE, "ACC");
        menumElements.put(TagMask.Case.DATIVE, "DAT");
        menumElements.put(TagMask.Case.NOMINATIVE, "NOM");
        menumElements.put(TagMask.Case.PREPOSITIVE, "PIV");
        menumElements.put(TagMask.Case.ACCUSATIVE_DATIVE, "ACC/DAT");
        menumElements.put(TagMask.Case.NOMINATIVE_PREPOSITIVE, "NOM/PIV");
        menumElements.put(TagMask.Person.FIRST, "1");
        menumElements.put(TagMask.Person.SECOND, "2");
        menumElements.put(TagMask.Person.THIRD, "3");
        menumElements.put(TagMask.Person.FIRST_THIRD, "1/3S");
        menumElements.put(TagMask.Person.NONE_FIRST_THIRD, "0/1/3S");
        menumElements.put(TagMask.Tense.PRESENT, "PR");
        menumElements.put(TagMask.Tense.PRETERITO_IMPERFEITO, "IMPF");
        menumElements.put(TagMask.Tense.PRETERITO_PERFEITO, "PS");
        menumElements.put(TagMask.Tense.PRETERITO_MAIS_QUE_PERFEITO, "MQP");
        menumElements.put(TagMask.Tense.FUTURE, "FUT");
        menumElements.put(TagMask.Tense.CONDITIONAL, "COND");
        menumElements.put(TagMask.Tense.PRETERITO_PERFEITO_MAIS_QUE_PERFEITO, "PS/MQP");
        menumElements.put(TagMask.Mood.INDICATIVE, "IND");
        menumElements.put(TagMask.Mood.SUBJUNCTIVE, "SUBJ");
        menumElements.put(TagMask.Mood.IMPERATIVE, "IMP");
        menumElements.put(TagMask.Punctuation.ABS, "ABS");
        menumElements.put(TagMask.Punctuation.NSEP, "NSEP");
        menumElements.put(TagMask.Punctuation.BIN, "BIN");
        menumElements.put(TagMask.Punctuation.REL, "REL");
        ENUM_MTAG_PARTS = Collections.unmodifiableMap(menumElements);
        Set<Enum<?>> k2 = ENUM_MTAG_PARTS.keySet();
        HashMap stringMElements = new HashMap(60);
        for (Enum<?> tagE : k2) {
            ArrayList values = new ArrayList();
            values.add(tagE);
            stringMElements.put(ENUM_MTAG_PARTS.get(tagE), Collections.unmodifiableList(values));
        }
        ArrayList<Enum> _1S = new ArrayList<Enum>();
        _1S.add(TagMask.Person.FIRST);
        _1S.add(TagMask.Number.SINGULAR);
        stringMElements.put("1S", Collections.unmodifiableList(_1S));
        ArrayList<Enum> _1P = new ArrayList<Enum>();
        _1P.add(TagMask.Person.FIRST);
        _1P.add(TagMask.Number.PLURAL);
        stringMElements.put("1P", Collections.unmodifiableList(_1P));
        ArrayList<Enum> _2S = new ArrayList<Enum>();
        _2S.add(TagMask.Person.SECOND);
        _2S.add(TagMask.Number.SINGULAR);
        stringMElements.put("2S", Collections.unmodifiableList(_2S));
        ArrayList<Enum> _2P = new ArrayList<Enum>();
        _2P.add(TagMask.Person.SECOND);
        _2P.add(TagMask.Number.PLURAL);
        stringMElements.put("2P", Collections.unmodifiableList(_2P));
        ArrayList<Enum> _3S = new ArrayList<Enum>();
        _3S.add(TagMask.Person.THIRD);
        _3S.add(TagMask.Number.SINGULAR);
        stringMElements.put("3S", Collections.unmodifiableList(_3S));
        ArrayList<Enum> _3P = new ArrayList<Enum>();
        _3P.add(TagMask.Person.THIRD);
        _3P.add(TagMask.Number.PLURAL);
        stringMElements.put("3P", Collections.unmodifiableList(_3P));
        ArrayList<Enum> _13S = new ArrayList<Enum>();
        _13S.add(TagMask.Person.FIRST_THIRD);
        _13S.add(TagMask.Number.SINGULAR);
        stringMElements.put("1/3S", Collections.unmodifiableList(_13S));
        ArrayList<Enum> _3SP = new ArrayList<Enum>();
        _3SP.add(TagMask.Person.THIRD);
        _3SP.add(TagMask.Number.NEUTRAL);
        stringMElements.put("3S/P", Collections.unmodifiableList(_3SP));
        ArrayList<Enum> _013S = new ArrayList<Enum>();
        _013S.add(TagMask.Person.NONE_FIRST_THIRD);
        _013S.add(TagMask.Number.SINGULAR);
        stringMElements.put("0/1/3S", Collections.unmodifiableList(_013S));
        ArrayList<Enum> hifen = new ArrayList<Enum>();
        hifen.add(TagMask.Class.PUNCTUATION_MARK);
        hifen.add(TagMask.Punctuation.REL);
        stringMElements.put("$--", Collections.unmodifiableList(hifen));
        ArrayList<Enum> ap = new ArrayList<Enum>();
        ap.add(TagMask.Class.PUNCTUATION_MARK);
        ap.add(TagMask.Punctuation.BIN);
        stringMElements.put("$`", Collections.unmodifiableList(ap));
        stringMElements.put("$\u00b4", Collections.unmodifiableList(ap));
        ArrayList<Enum> others = new ArrayList<Enum>();
        others.add(TagMask.Class.PUNCTUATION_MARK);
        others.add(TagMask.Punctuation.NSEP);
        stringMElements.put("$+", Collections.unmodifiableList(others));
        stringMElements.put("$\u00b1", Collections.unmodifiableList(others));
        stringMElements.put("$=", Collections.unmodifiableList(others));
        stringMElements.put("$$", Collections.unmodifiableList(others));
        stringMElements.put("$\\", Collections.unmodifiableList(others));
        ArrayList<TagMask.Class> pronouns = new ArrayList<TagMask.Class>();
        pronouns.add(TagMask.Class.PRONOUN);
        stringMElements.put("pron-det", Collections.unmodifiableList(pronouns));
        stringMElements.put("pron-indp", Collections.unmodifiableList(pronouns));
        ArrayList<TagMask.Class> pp = new ArrayList<TagMask.Class>();
        pp.add(TagMask.Class.PREPOSITION);
        stringMElements.put("PP", Collections.unmodifiableList(pp));
        MTAG_PARTS_ENUM = Collections.unmodifiableMap(stringMElements);
    }
}

