/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.checkers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.cogroo.entities.Mistake;
import org.cogroo.text.Chunk;
import org.cogroo.text.Sentence;
import org.cogroo.text.SyntacticChunk;
import org.cogroo.text.Token;
import org.cogroo.tools.checker.AbstractChecker;
import org.cogroo.tools.checker.JavaRuleDefinition;
import org.cogroo.tools.checker.rules.model.Example;
import org.cogroo.tools.checker.rules.verbs.Prep;
import org.cogroo.tools.checker.rules.verbs.VerbPlusPreps;
import org.cogroo.tools.checker.rules.verbs.Verbs;

public class GovernmentChecker
extends AbstractChecker {
    private static final String ID_PREFIX = "government:";
    private final Verbs verbs;
    static final String ID = "government:GOVERNMENT";
    static final String CATEGORY = "Erros sint\u00e1ticos";
    static final String GROUP = "Reg\u00eancia verbal";
    static final String DESCRIPTION = "Procura por verbos e analisa sua reg\u00eancia.";
    static final String MESSAGE = "Problema com a reg\u00eancia verbal";
    static final String SHORT = "Reg\u00eancia verbal.";

    public GovernmentChecker() {
        ArrayList<Example> examples = new ArrayList<Example>();
        examples.add(GovernmentChecker.createExample("Ele assiste o filme.", "Ele assiste ao filme."));
        JavaRuleDefinition wordCombination = new JavaRuleDefinition(ID, CATEGORY, GROUP, DESCRIPTION, MESSAGE, SHORT, examples);
        this.add(wordCombination);
        this.verbs = new Verbs();
    }

    @Override
    public String getIdPrefix() {
        return ID_PREFIX;
    }

    @Override
    public int getPriority() {
        return 211;
    }

    @Override
    public List<Mistake> check(Sentence sentence) {
        LinkedList<Mistake> mistakes = new LinkedList<Mistake>();
        int offset = sentence.getStart();
        Token verb = this.findVerb(sentence);
        List<Token> nouns = this.findNouns(sentence);
        if (verb != null && verb.getLemmas().length > 0) {
            VerbPlusPreps vpp = this.verbs.getVerb(verb.getLemmas()[0]);
            if (nouns != null && nouns.size() > 0) {
                for (Token noun : nouns) {
                    int end;
                    int start;
                    Prep prep;
                    if (vpp == null || (prep = vpp.findWord(noun.getLexeme())) == null) continue;
                    Token sentPrep = this.findPrep(sentence, noun);
                    if (sentPrep != null) {
                        if (sentPrep.getLexeme().equals(prep.getPreposition())) continue;
                        start = sentPrep.getStart() + offset;
                        end = sentPrep.getEnd() + offset;
                        mistakes.add(this.createMistake(ID, this.createSuggestion(verb, sentPrep, prep), start, end, sentence.getText()));
                        continue;
                    }
                    if (prep.getPreposition().equals("_")) continue;
                    start = verb.getStart() + offset;
                    end = verb.getEnd() + offset;
                    mistakes.add(this.createMistake(ID, this.createSuggestion(verb, sentPrep, prep), start, end, sentence.getText()));
                }
            }
        }
        return mistakes;
    }

    public List<Token> findNouns(Sentence sentence) {
        ArrayList<Token> nouns = new ArrayList<Token>();
        List syntChunks = sentence.getSyntacticChunks();
        for (int i = 0; i < syntChunks.size(); ++i) {
            String tag = ((SyntacticChunk)syntChunks.get(i)).getTag();
            if (!tag.equals("PIV") && !tag.equals("ACC") && !tag.equals("SC")) continue;
            for (Token token : ((SyntacticChunk)syntChunks.get(i)).getTokens()) {
                if (!token.getPOSTag().equals("n") && !token.getPOSTag().equals("pron-pers") && !token.getPOSTag().equals("prop")) continue;
                nouns.add(token);
            }
        }
        return nouns;
    }

    public Token findVerb(Sentence sentence) {
        List syntChunks = sentence.getSyntacticChunks();
        for (int i = 0; i < syntChunks.size(); ++i) {
            String tag = ((SyntacticChunk)syntChunks.get(i)).getTag();
            if (!tag.equals("P") && !tag.equals("MV") && !tag.equals("PMV") && !tag.equals("AUX") && !tag.equals("PAUX")) continue;
            return (Token)((SyntacticChunk)syntChunks.get(i)).getTokens().get(0);
        }
        return null;
    }

    private String[] createSuggestion(Token token, Token sentPrep, Prep prep) {
        String[] array = null;
        array = prep.getPreposition().equals("_") ? new String[]{token.getLexeme() + " "} : new String[]{token.getLexeme() + " " + prep.getPreposition()};
        return array;
    }

    public Token findPrep(Sentence sentence, Token token) {
        List chunks = sentence.getChunks();
        for (int i = 1; i < chunks.size(); ++i) {
            Chunk atual = (Chunk)chunks.get(i);
            if (!atual.getTokens().contains(token)) continue;
            List tokens = ((Chunk)chunks.get(i - 1)).getTokens();
            for (Token prep : tokens) {
                if (!prep.getPOSTag().equals("prp")) continue;
                return prep;
            }
        }
        return null;
    }
}

