/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.checkers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.cogroo.analyzer.Analyzer;
import org.cogroo.entities.Mistake;
import org.cogroo.text.Document;
import org.cogroo.text.Sentence;
import org.cogroo.text.Token;
import org.cogroo.text.impl.DocumentImpl;
import org.cogroo.tools.checker.AbstractChecker;
import org.cogroo.tools.checker.JavaRuleDefinition;
import org.cogroo.tools.checker.rules.model.Example;
import org.cogroo.tools.checker.rules.paronym.ParonymList;
import org.cogroo.tools.checker.rules.util.RuleUtils;

public class ParonymChecker
extends AbstractChecker {
    private static final String ID_PREFIX = "probs:";
    static final String ID = "probs:paronyms";
    static final String CATEGORY = "Enganos ortogr\u00e1ficos";
    static final String GROUP = "Ortografia";
    static final String DESCRIPTION = "Procura por enganos em par\u00f4nimos.";
    static final String MESSAGE = "Se a classe de %s for %s, use %s.";
    static final String SHORT = "Poss\u00edvel confus\u00e3o entre %s e %s.";
    private static final Logger LOGGER = Logger.getLogger(ParonymChecker.class);
    private Analyzer analyzer;
    private final ParonymList dictionary;
    private Map<String, String> map;

    public ParonymChecker(Analyzer analyzer) {
        this.analyzer = analyzer;
        ArrayList<Example> examples = new ArrayList<Example>();
        examples.add(ParonymChecker.createExample("Eu tenho uma duvida.", "Eu tenho uma d\u00favida."));
        JavaRuleDefinition definition = new JavaRuleDefinition(ID, CATEGORY, GROUP, DESCRIPTION, MESSAGE, SHORT, examples);
        this.add(definition);
        this.dictionary = new ParonymList();
        this.map = this.dictionary.getParonymsMap();
    }

    @Override
    public String getIdPrefix() {
        return ID_PREFIX;
    }

    @Override
    public int getPriority() {
        return 311;
    }

    @Override
    public List<Mistake> check(Sentence sentence) {
        ArrayList<Mistake> mistakes = new ArrayList<Mistake>();
        if (sentence.getTokens().size() < 2) {
            return mistakes;
        }
        for (int i = 0; i < sentence.getTokens().size(); ++i) {
            Token originalToken = (Token)sentence.getTokens().get(i);
            String wanted = originalToken.getLexeme();
            String wantedLowerCase = wanted.toLowerCase();
            if (!this.map.containsKey(wantedLowerCase)) continue;
            String candidate = RuleUtils.useCasedString(wanted, this.map.get(wantedLowerCase));
            String sentenceText = sentence.getText();
            String alternativeText = sentenceText.substring(0, originalToken.getStart()) + candidate + sentenceText.substring(originalToken.getEnd());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("\n****** Senten\u00e7a alternativa **********:\n" + alternativeText));
            }
            DocumentImpl alternative = new DocumentImpl(alternativeText);
            this.analyzer.analyze((Document)alternative);
            Sentence alternativeSentence = (Sentence)alternative.getSentences().get(0);
            if (!(alternativeSentence.getTokensProb() - sentence.getTokensProb() > 0.1)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Prob original: " + sentence.getTokensProb()));
                LOGGER.debug((Object)("Prob alternat: " + alternativeSentence.getTokensProb()));
                LOGGER.debug((Object)("\n****** Poss\u00edvel corre\u00e7\u00e3o **********:\n" + sentenceText + " -> " + alternativeText));
            }
            Token alternativeToken = (Token)alternativeSentence.getTokens().get(i);
            String[] suggestions = new String[]{candidate};
            String[] longMsgArgs = new String[]{wanted, RuleUtils.translate(alternativeToken.getPOSTag()), candidate};
            String[] shortMsgArgs = new String[]{wanted, candidate};
            mistakes.add(this.createMistake(ID, longMsgArgs, shortMsgArgs, suggestions, originalToken.getStart(), originalToken.getEnd(), sentence.getText()));
        }
        return mistakes;
    }
}

