/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.rules.applier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import opennlp.tools.util.Span;
import org.apache.log4j.Logger;
import org.cogroo.entities.Chunk;
import org.cogroo.entities.Mistake;
import org.cogroo.entities.Sentence;
import org.cogroo.entities.SyntacticChunk;
import org.cogroo.entities.Token;
import org.cogroo.entities.TokenGroup;
import org.cogroo.entities.impl.ChunkCogroo;
import org.cogroo.entities.impl.ChunkTag;
import org.cogroo.entities.impl.MistakeImpl;
import org.cogroo.entities.impl.MorphologicalTag;
import org.cogroo.entities.impl.SyntacticTag;
import org.cogroo.entities.impl.TokenCogroo;
import org.cogroo.tools.checker.RuleDefinition;
import org.cogroo.tools.checker.TypedChecker;
import org.cogroo.tools.checker.rules.applier.AcceptState;
import org.cogroo.tools.checker.rules.applier.NullSyntacticChunk;
import org.cogroo.tools.checker.rules.applier.RulesTree;
import org.cogroo.tools.checker.rules.applier.RulesTreesProvider;
import org.cogroo.tools.checker.rules.applier.RulesXmlAccess;
import org.cogroo.tools.checker.rules.applier.State;
import org.cogroo.tools.checker.rules.applier.SuggestionBuilder;
import org.cogroo.tools.checker.rules.applier.XMLRuleDefinition;
import org.cogroo.tools.checker.rules.dictionary.CogrooTagDictionary;
import org.cogroo.tools.checker.rules.model.Boundaries;
import org.cogroo.tools.checker.rules.model.Element;
import org.cogroo.tools.checker.rules.model.Mask;
import org.cogroo.tools.checker.rules.model.PatternElement;
import org.cogroo.tools.checker.rules.model.Rule;
import org.cogroo.tools.checker.rules.model.TagMask;
import org.cogroo.tools.checker.rules.util.RuleUtils;
import org.cogroo.tools.checker.rules.util.RulesProperties;

public final class RulesApplier
implements TypedChecker {
    private SuggestionBuilder suggestionBuilder;
    private static final Logger LOGGER = Logger.getLogger(RulesApplier.class);
    public static final String ID_PREFIX = "xml:";
    private static final String OUT_OF_BOUNDS = "%%OUT_OF_BOUNDS%%";
    private final Set<String> ignoredRules = new HashSet<String>();
    private final RulesTreesProvider rulesTreesProvider;
    private CogrooTagDictionary dictionary;
    private Collection<RuleDefinition> definitions;

    public RulesApplier(RulesTreesProvider rulesTreesProvider, CogrooTagDictionary dictionary) {
        this.rulesTreesProvider = rulesTreesProvider;
        this.dictionary = dictionary;
        this.suggestionBuilder = new SuggestionBuilder(this.dictionary);
    }

    @Override
    public List<Mistake> check(Sentence sentence) {
        RulesTree rulesTree;
        long start = 0L;
        if (LOGGER.isDebugEnabled()) {
            start = System.nanoTime();
        }
        this.insertOutOfBounds(sentence);
        List<Mistake> mistakes = new ArrayList<Mistake>();
        if (RulesProperties.APPLY_LOCAL) {
            rulesTree = this.rulesTreesProvider.getTrees().getGeneral();
            for (int i = 0; i < sentence.getTokens().size(); ++i) {
                List<State> nextStates = rulesTree.getRoot().getNextStates();
                mistakes = this.getMistakes(mistakes, nextStates, sentence, i, i, new ArrayList<Token>(), sentence);
            }
        }
        sentence.setTokens(sentence.getTokens().subList(1, sentence.getTokens().size() - 1));
        if (RulesProperties.APPLY_PHRASE_LOCAL) {
            rulesTree = this.rulesTreesProvider.getTrees().getPhraseLocal();
            List<Chunk> chunks = sentence.getChunks();
            for (int i = 0; i < chunks.size(); ++i) {
                for (int j = 0; j < chunks.get(i).getTokens().size(); ++j) {
                    List<State> nextStates = rulesTree.getRoot().getNextStates();
                    mistakes = this.getMistakes(mistakes, nextStates, chunks.get(i), j, j, new ArrayList<Token>(), sentence);
                }
            }
        }
        if (RulesProperties.APPLY_SUBJECT_VERB) {
            rulesTree = this.rulesTreesProvider.getTrees().getSubjectVerb();
            List<SyntacticChunk> syntacticChunks = sentence.getSyntacticChunks();
            for (int i = 0; i < syntacticChunks.size(); ++i) {
                List<State> nextStates = rulesTree.getRoot().getNextStates();
                mistakes = this.getMistakes(mistakes, nextStates, syntacticChunks, i, i, new ArrayList<SyntacticChunk>(), sentence);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Rules applied in " + (System.nanoTime() - start) / 1000L + "us"));
        }
        this.filterIgnoredRules(mistakes);
        return mistakes;
    }

    private void insertOutOfBounds(Sentence sentence) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        TokenCogroo empty1 = new TokenCogroo(OUT_OF_BOUNDS, new Span(0, 0));
        empty1.setMorphologicalTag(new MorphologicalTag());
        ChunkTag ct = new ChunkTag();
        ct.setChunkFunction(TagMask.ChunkFunction.OTHER);
        empty1.setChunkTag(ct);
        tokens.add(empty1);
        tokens.addAll(sentence.getTokens());
        TokenCogroo empty2 = new TokenCogroo(OUT_OF_BOUNDS, new Span(0, 0));
        empty2.setMorphologicalTag(new MorphologicalTag());
        empty2.setChunkTag(ct);
        tokens.add(empty2);
        sentence.setTokens(tokens);
        ArrayList<Chunk> chunkz = new ArrayList<Chunk>();
        ChunkCogroo chunk1 = new ChunkCogroo(Collections.singletonList(empty1), 0);
        ((Chunk)chunk1).setMorphologicalTag(new MorphologicalTag());
        empty1.setChunk(chunk1);
        chunkz.add(chunk1);
        chunkz.addAll(sentence.getChunks());
        ChunkCogroo chunk2 = new ChunkCogroo(Collections.singletonList(empty2), 0);
        ((Chunk)chunk2).setMorphologicalTag(new MorphologicalTag());
        empty2.setChunk(chunk2);
        chunkz.add(chunk2);
        sentence.setChunks(chunkz);
        ArrayList<SyntacticChunk> synts = new ArrayList<SyntacticChunk>();
        SyntacticChunk synt1 = new SyntacticChunk(Collections.singletonList(chunk1));
        SyntacticTag st = new SyntacticTag();
        st.setSyntacticFunction(TagMask.SyntacticFunction.NONE);
        synt1.setSyntacticTag(st);
        empty1.setSyntacticChunk(synt1);
        synts.add(synt1);
        synts.addAll(sentence.getSyntacticChunks());
        SyntacticChunk synt2 = new SyntacticChunk(Collections.singletonList(chunk1));
        synt2.setSyntacticTag(st);
        empty2.setSyntacticChunk(synt2);
        synts.add(synt2);
        sentence.setSyntacticChunks(synts);
    }

    private List<Mistake> getMistakes(List<Mistake> mistakes, List<State> currentStates, TokenGroup tokenGroup, int baseTokenIndex, int currentTokenIndex, ArrayList<Token> matched, Sentence sentence) {
        int offset = 0;
        if (tokenGroup instanceof Chunk) {
            offset = ((Chunk)tokenGroup).getFirstToken();
        }
        for (State state : currentStates) {
            PatternElement patternElement = state.getElement();
            Token token = tokenGroup.getTokens().get(currentTokenIndex);
            boolean tokenAndElementMatched = this.match(token, patternElement, baseTokenIndex + offset, sentence);
            if (tokenAndElementMatched) {
                ArrayList<Token> matchedClone = this.cloneList(matched);
                matchedClone.add(token);
                if (state instanceof AcceptState) {
                    Rule rule = ((AcceptState)state).getRule();
                    int lower = baseTokenIndex + rule.getBoundaries().getLower();
                    int upper = currentTokenIndex + rule.getBoundaries().getUpper();
                    int lowerCountedByChars = sentence.getTokens().get(lower += offset).getSpan().getStart();
                    int upperCountedByChars = sentence.getTokens().get(upper += offset).getSpan().getEnd();
                    String[] suggestions = new String[]{};
                    Token next = null;
                    if (tokenGroup.getTokens().size() > currentTokenIndex + 1) {
                        next = tokenGroup.getTokens().get(currentTokenIndex + 1);
                    }
                    try {
                        suggestions = this.suggestionBuilder.getTokenSuggestions(sentence, matchedClone, next, rule);
                    }
                    catch (NullPointerException e) {
                        LOGGER.error((Object)("Failed to apply rule " + rule.getId() + " in: " + sentence.getSentence()), (Throwable)e);
                    }
                    MistakeImpl mistake = new MistakeImpl(ID_PREFIX + rule.getId(), this.getPriority(rule), rule.getMessage(), rule.getShortMessage(), suggestions, lowerCountedByChars + sentence.getOffset(), upperCountedByChars + sentence.getOffset(), rule.getExample(), sentence.getDocumentText());
                    mistakes.add(mistake);
                    continue;
                }
                if (currentTokenIndex + 1 >= tokenGroup.getTokens().size()) continue;
                this.getMistakes(mistakes, state.getNextStates(), tokenGroup, baseTokenIndex, currentTokenIndex + 1, matchedClone, sentence);
                continue;
            }
            if (!this.isOptional(patternElement)) continue;
            this.getMistakes(mistakes, state.getNextStates(), tokenGroup, baseTokenIndex, currentTokenIndex, matched, sentence);
        }
        return mistakes;
    }

    private boolean isOptional(PatternElement patternElement) {
        return patternElement.isOptional() != null && patternElement.isOptional() != false;
    }

    private int getPriority(Rule rule) {
        if (rule.getPriority() != null) {
            return rule.getPriority().intValue();
        }
        return (int)((long)this.getPriority() - rule.getId());
    }

    private List<Mistake> getMistakes(List<Mistake> mistakes, List<State> currentStates, List<SyntacticChunk> syntacticChunks, int baseChunkIndex, int currentChunkIndex, ArrayList<SyntacticChunk> matched, Sentence sentence) {
        for (State state : currentStates) {
            ArrayList<SyntacticChunk> matchedClone;
            PatternElement patternElement = state.getElement();
            SyntacticChunk sc = syntacticChunks.get(currentChunkIndex);
            boolean chunkAndElementMatched = this.match(sc, patternElement, baseChunkIndex, sentence);
            if (chunkAndElementMatched) {
                matchedClone = this.cloneList(matched);
                matchedClone.add(sc);
                if (state instanceof AcceptState) {
                    Rule rule = ((AcceptState)state).getRule();
                    Boundaries b = rule.getBoundaries();
                    int start = matchedClone.get(b.getLower()).getTokens().get(0).getSpan().getStart() + sentence.getOffset();
                    List<Token> lastChk = matchedClone.get(matchedClone.size() - 1 + b.getUpper()).getTokens();
                    int end = lastChk.get(lastChk.size() - 1).getSpan().getEnd() + sentence.getOffset();
                    String[] suggestions = this.suggestionBuilder.getSyntacticSuggestions(sentence, matchedClone, null, rule);
                    MistakeImpl mistake = new MistakeImpl(ID_PREFIX + rule.getId(), this.getPriority(rule), rule.getMessage(), rule.getShortMessage(), suggestions, start, end, rule.getExample(), sentence.getDocumentText());
                    mistakes.add(mistake);
                    continue;
                }
                if (currentChunkIndex + 1 >= syntacticChunks.size()) continue;
                this.getMistakes(mistakes, state.getNextStates(), syntacticChunks, baseChunkIndex, currentChunkIndex + 1, matchedClone, sentence);
                continue;
            }
            if (!this.isOptional(patternElement)) continue;
            matchedClone = this.cloneList(matched);
            matchedClone.add(NullSyntacticChunk.instance());
            this.getMistakes(mistakes, state.getNextStates(), syntacticChunks, baseChunkIndex, currentChunkIndex, matchedClone, sentence);
        }
        return mistakes;
    }

    private boolean match(Token token, PatternElement patternElement, int baseTokenIndex, Sentence sentence) {
        if (patternElement.getElement() != null) {
            return this.match(token, patternElement.getElement(), baseTokenIndex, sentence);
        }
        if (patternElement.getComposition().getAnd() != null) {
            List<PatternElement> l = patternElement.getComposition().getAnd().getPatternElement();
            for (PatternElement pe : l) {
                boolean match = this.match(token, pe, baseTokenIndex, sentence);
                if (match) continue;
                return false;
            }
            return true;
        }
        if (patternElement.getComposition().getOr() != null) {
            List<PatternElement> l = patternElement.getComposition().getOr().getPatternElement();
            for (PatternElement pe : l) {
                boolean match = this.match(token, pe, baseTokenIndex, sentence);
                if (!match) continue;
                return true;
            }
            return false;
        }
        LOGGER.error((Object)"Shouldn't get here.");
        return false;
    }

    private boolean match(SyntacticChunk chunk, PatternElement patternElement, int baseTokenIndex, Sentence sentence) {
        if (patternElement.getElement() != null) {
            return this.match(chunk, patternElement.getElement(), baseTokenIndex, sentence);
        }
        if (patternElement.getComposition().getAnd() != null) {
            List<PatternElement> l = patternElement.getComposition().getAnd().getPatternElement();
            for (PatternElement pe : l) {
                boolean match = this.match(chunk, pe, baseTokenIndex, sentence);
                if (match) continue;
                return false;
            }
            return true;
        }
        if (patternElement.getComposition().getOr() != null) {
            List<PatternElement> l = patternElement.getComposition().getOr().getPatternElement();
            for (PatternElement pe : l) {
                boolean match = this.match(chunk, pe, baseTokenIndex, sentence);
                if (!match) continue;
                return true;
            }
            return false;
        }
        LOGGER.error((Object)"Shouldn't get here.");
        return false;
    }

    private boolean match(Token token, Element element, int baseTokenIndex, Sentence sentence) {
        boolean negated;
        boolean match;
        if (element.isNegated() == null) {
            match = false;
            negated = false;
        } else {
            match = element.isNegated();
            negated = element.isNegated();
        }
        for (Mask mask : element.getMask()) {
            if (!negated) {
                if (mask.getLexemeMask() != null && mask.getLexemeMask().equalsIgnoreCase(token.getLexeme())) {
                    match = true;
                    continue;
                }
                if (mask.getPrimitiveMask() != null && this.matchLemma(token, mask.getPrimitiveMask())) {
                    match = true;
                    continue;
                }
                if (mask.getTagMask() != null && token.getMorphologicalTag() != null) {
                    match |= token.getMorphologicalTag().matchExact(mask.getTagMask(), false);
                    continue;
                }
                if (mask.getTagReference() != null && token.getMorphologicalTag() != null) {
                    match |= token.getMorphologicalTag().match(RuleUtils.createTagMaskFromReference(mask.getTagReference(), sentence, baseTokenIndex), false);
                    continue;
                }
                if (mask.getOutOfBounds() == null || baseTokenIndex != 0 && baseTokenIndex != sentence.getTokens().size() - 1) continue;
                match = false;
                continue;
            }
            if (mask.getLexemeMask() != null && mask.getLexemeMask().equalsIgnoreCase(token.getLexeme())) {
                match = false;
                continue;
            }
            if (mask.getPrimitiveMask() != null && this.matchLemma(token, mask.getPrimitiveMask())) {
                match = false;
                continue;
            }
            if (mask.getTagMask() != null && token != null && token.getMorphologicalTag() != null) {
                match &= !token.getMorphologicalTag().matchExact(mask.getTagMask(), false);
                continue;
            }
            if (mask.getTagReference() != null && token != null && token.getMorphologicalTag() != null) {
                match &= !token.getMorphologicalTag().match(RuleUtils.createTagMaskFromReference(mask.getTagReference(), sentence, baseTokenIndex), false);
                continue;
            }
            if (mask.getOutOfBounds() == null || baseTokenIndex != 0 && baseTokenIndex != sentence.getTokens().size() - 1) continue;
            match = false;
        }
        return match;
    }

    private boolean match(SyntacticChunk chunk, Element element, int baseTokenIndex, Sentence sentence) {
        boolean negated;
        boolean match;
        if (element.isNegated() == null) {
            match = false;
            negated = false;
        } else {
            match = element.isNegated();
            negated = element.isNegated();
        }
        for (Mask mask : element.getMask()) {
            TagMask t;
            if (!negated) {
                if (mask.getLexemeMask() != null && mask.getLexemeMask().equalsIgnoreCase(chunk.toPlainText())) {
                    match = true;
                    continue;
                }
                if (mask.getTagMask() != null && chunk.getMorphologicalTag() != null) {
                    match |= chunk.getMorphologicalTag().matchExact(mask.getTagMask(), false) && chunk.getSyntacticTag().match(mask.getTagMask());
                    continue;
                }
                if (mask.getPrimitiveMask() != null && this.matchLemma(chunk.getChildChunks().get(0).getMainToken(), mask.getPrimitiveMask())) {
                    match = true;
                    continue;
                }
                if (mask.getTagReference() != null && chunk.getMorphologicalTag() != null) {
                    t = RuleUtils.createTagMaskFromReferenceSyntatic(mask.getTagReference(), sentence, baseTokenIndex);
                    match |= chunk.getMorphologicalTag().match(t, false) && (t.getSyntacticFunction() == null || chunk.getSyntacticTag().match(t));
                    continue;
                }
                if (mask.getOutOfBounds() == null || !chunk.getTokens().get(0).getLexeme().equals(OUT_OF_BOUNDS)) continue;
                match = true;
                continue;
            }
            if (mask.getLexemeMask() != null && mask.getLexemeMask().equalsIgnoreCase(chunk.toPlainText())) {
                match = false;
                continue;
            }
            if (mask.getTagMask() != null) {
                match &= !chunk.getMorphologicalTag().matchExact(mask.getTagMask(), false) || mask.getTagMask().getSyntacticFunction() != null && !chunk.getSyntacticTag().match(mask.getTagMask());
                continue;
            }
            if (mask.getPrimitiveMask() != null && this.matchLemma(chunk.getChildChunks().get(0).getMainToken(), mask.getPrimitiveMask())) {
                match = false;
                continue;
            }
            if (mask.getTagReference() != null) {
                t = RuleUtils.createTagMaskFromReferenceSyntatic(mask.getTagReference(), sentence, baseTokenIndex);
                match &= !chunk.getMorphologicalTag().match(t, false) || t.getSyntacticFunction() != null && !chunk.getSyntacticTag().match(t);
                continue;
            }
            if (mask.getOutOfBounds() == null || sentence.getSyntacticChunks().indexOf(chunk) != sentence.getSyntacticChunks().size() - 1) continue;
            match = false;
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ignore(String ruleID) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Adding rule to ignored list. ID: " + ruleID));
        }
        Set<String> set = this.ignoredRules;
        synchronized (set) {
            this.ignoredRules.add(ruleID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetIgnored() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Reset ignored list.");
        }
        Set<String> set = this.ignoredRules;
        synchronized (set) {
            this.ignoredRules.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterIgnoredRules(List<Mistake> rules) {
        ArrayList<Mistake> ret = new ArrayList<Mistake>();
        Set<String> set = this.ignoredRules;
        synchronized (set) {
            if (this.ignoredRules.size() == 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"No rules to ignore.");
                }
                return;
            }
            for (int i = 0; i < rules.size(); ++i) {
                if (this.ignoredRules.contains(rules.get(i).getRuleIdentifier())) continue;
                ret.add(rules.get(i));
            }
            int n = rules.size() - ret.size();
            if (n != 0) {
                rules.clear();
                rules.addAll(ret);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Ignored " + n + " rules."));
            }
        }
    }

    public List<String> getCategories() {
        return null;
    }

    @Override
    public String getIdPrefix() {
        return ID_PREFIX;
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    @Override
    public synchronized Collection<RuleDefinition> getRulesDefinition() {
        if (this.definitions != null) {
            return this.definitions;
        }
        List<Rule> rules = RulesXmlAccess.getInstance().getRules().getRule();
        ArrayList<XMLRuleDefinition> d = new ArrayList<XMLRuleDefinition>(rules.size());
        for (Rule rule : rules) {
            d.add(new XMLRuleDefinition(ID_PREFIX, rule));
        }
        this.definitions = Collections.unmodifiableCollection(d);
        return this.definitions;
    }

    private boolean matchLemma(Token token, String primitiveMask) {
        boolean match = false;
        String[] lemmas = token.getPrimitive();
        if (lemmas != null) {
            for (String lemma : lemmas) {
                if (!lemma.equalsIgnoreCase(primitiveMask)) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    private <T> ArrayList<T> cloneList(ArrayList<T> matched) {
        return (ArrayList)matched.clone();
    }
}

