/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.rules.dictionary;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cogroo.dictionary.impl.FSADictionary;
import org.cogroo.dictionary.impl.FSASynthDictionary;
import org.cogroo.tools.checker.rules.dictionary.LexicalDictionary;
import org.cogroo.util.PairWordPOSTag;

public class FSALexicalDictionary
implements LexicalDictionary {
    private FSADictionary dictionary = null;
    private FSASynthDictionary synthDict = FSASynthDictionary.createFromResources((String)"/fsa_dictionaries/featurizer/pt_br_feats_synth.dict");

    public FSALexicalDictionary() throws IllegalArgumentException, IOException {
        this.dictionary = FSADictionary.createFromResources((String)"/fsa_dictionaries/featurizer/pt_br_feats.dict");
    }

    @Override
    public boolean wordExists(String word) {
        return this.dictionary.getTags(word) != null;
    }

    @Override
    public List<PairWordPOSTag> getWordsAndPosTagsForLemma(String aLemma) {
        return this.synthDict.synthesize(aLemma);
    }

    @Override
    public List<PairWordPOSTag> getLemmasAndPosTagsForWord(String aWord) {
        return this.dictionary.getTagsAndLemms(aWord);
    }

    @Override
    public List<String> getPOSTagsForWord(String word) {
        String[] tags = this.dictionary.getTags(word);
        if (tags != null) {
            return Collections.unmodifiableList(Arrays.asList(tags));
        }
        return Collections.emptyList();
    }
}

