/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.rules.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.cogroo.entities.impl.MorphologicalTag;
import org.cogroo.interpreters.TagInterpreter;
import org.cogroo.tools.checker.rules.dictionary.CogrooTagDictionary;
import org.cogroo.tools.checker.rules.dictionary.LexicalDictionary;
import org.cogroo.tools.checker.rules.model.TagMask;
import org.cogroo.util.PairWordPOSTag;

public class TagDictionary
implements CogrooTagDictionary {
    private static final Logger LOGGER = Logger.getLogger(TagDictionary.class);
    LexicalDictionary access;
    private boolean caseSensitive;
    private TagInterpreter dicTI;

    public TagDictionary(LexicalDictionary access, boolean caseSensitive, TagInterpreter tagInterpreter) {
        this.dicTI = tagInterpreter;
        this.caseSensitive = caseSensitive;
        this.access = access;
    }

    @Override
    public boolean exists(String word, boolean cs) {
        if (cs) {
            return this.access.wordExists(word);
        }
        return this.access.wordExists(word.toLowerCase());
    }

    @Override
    public String[] getInflectedPrimitive(String primitive, TagMask tagMask, boolean cs) {
        List<PairWordPOSTag> lemmaTag = cs ? this.access.getWordsAndPosTagsForLemma(primitive) : this.access.getWordsAndPosTagsForLemma(primitive.toLowerCase());
        if (lemmaTag == null) {
            lemmaTag = new ArrayList<PairWordPOSTag>();
        }
        HashSet<String> inflectedLexemes = new HashSet<String>(lemmaTag.size());
        for (PairWordPOSTag pair : lemmaTag) {
            MorphologicalTag t = this.dicTI.parseMorphologicalTag(pair.getPosTag());
            if (!t.match(tagMask)) continue;
            inflectedLexemes.add(pair.getWord());
        }
        return inflectedLexemes.toArray(new String[inflectedLexemes.size()]);
    }

    @Override
    public String[] getPrimitive(String lexeme, TagMask tagMask, boolean cs) {
        HashSet<String> primitiveSet = new HashSet<String>();
        List<PairWordPOSTag> pairs = cs ? this.access.getLemmasAndPosTagsForWord(lexeme) : this.access.getLemmasAndPosTagsForWord(lexeme.toLowerCase());
        for (PairWordPOSTag lemmaPOSTag : pairs) {
            if (!this.dicTI.parseMorphologicalTag(lemmaPOSTag.getPosTag()).match(tagMask)) continue;
            primitiveSet.add(lemmaPOSTag.getWord());
        }
        if (primitiveSet.isEmpty()) {
            primitiveSet.add("");
        }
        return primitiveSet.toArray(new String[primitiveSet.size()]);
    }

    @Override
    public String[] getPrimitive(String lexeme, MorphologicalTag morphologicalTag, boolean cs) {
        HashSet<String> primitiveSet = new HashSet<String>();
        List<PairWordPOSTag> pairs = cs ? this.access.getLemmasAndPosTagsForWord(lexeme) : this.access.getLemmasAndPosTagsForWord(lexeme.toLowerCase());
        for (PairWordPOSTag lemmaPOSTag : pairs) {
            if (!this.dicTI.parseMorphologicalTag(lemmaPOSTag.getPosTag()).match(morphologicalTag)) continue;
            primitiveSet.add(lemmaPOSTag.getWord());
        }
        if (primitiveSet.isEmpty()) {
            return null;
        }
        return primitiveSet.toArray(new String[primitiveSet.size()]);
    }

    @Override
    public boolean match(String lexeme, TagMask tagMask, boolean cs) {
        List<PairWordPOSTag> pairs = cs ? this.access.getLemmasAndPosTagsForWord(lexeme) : this.access.getLemmasAndPosTagsForWord(lexeme.toLowerCase());
        for (PairWordPOSTag lemmaPOSTag : pairs) {
            MorphologicalTag m = this.dicTI.parseMorphologicalTag(lemmaPOSTag.getPosTag());
            if (!m.match(tagMask)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MorphologicalTag[] getTags(String word, boolean cs) {
        List<String> t;
        if (cs) {
            return this.convertToTargetConvention(this.access.getPOSTagsForWord(word));
        }
        String lowerCaseWord = word.toLowerCase();
        if (lowerCaseWord.equals(word)) {
            return this.convertToTargetConvention(this.access.getPOSTagsForWord(word));
        }
        HashSet<String> tags = new HashSet<String>();
        List<String> lc = this.access.getPOSTagsForWord(lowerCaseWord);
        if (lc != null) {
            tags.addAll(lc);
        }
        if ((t = this.access.getPOSTagsForWord(word)) != null) {
            tags.addAll(t);
        }
        return this.convertToTargetConvention(tags);
    }

    @Override
    public MorphologicalTag[] getTags(String word) {
        return this.getTags(word, this.caseSensitive);
    }

    public MorphologicalTag convertToTargetConvention(String ori) {
        return this.dicTI.parseMorphologicalTag(ori);
    }

    private MorphologicalTag[] convertToTargetConvention(Collection<String> ori) {
        if (ori == null) {
            return null;
        }
        ArrayList<MorphologicalTag> tag = new ArrayList<MorphologicalTag>(ori.size());
        for (String morphologicalTag : ori) {
            tag.add(this.convertToTargetConvention(morphologicalTag));
        }
        return tag.toArray(new MorphologicalTag[tag.size()]);
    }

    @Override
    public TagInterpreter getTagInterpreter() {
        return this.dicTI;
    }
}

